% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_wbt_removesinks.R
\name{ch_wbt_removesinks}
\alias{ch_wbt_removesinks}
\title{Removes sinks from a DEM}
\usage{
ch_wbt_removesinks(
  in_dem,
  out_dem,
  method = "breach_leastcost",
  dist = NULL,
  fn_dem_fsc = NULL,
  ...
)
}
\arguments{
\item{in_dem}{File path for original dem. Required.}

\item{out_dem}{File path for dem after removing sinks.}

\item{method}{Method for removing sinks. Default method is \option{breach_leastcost}. Other methods include
\option{breach}, \option{fill}, \option{fill_pd} (Planchon and Darboux), and \option{fill_wl} (Wang and Liu).}

\item{dist}{Maximum search distance for breach paths in cells. Required if \code{method = "breach_leastcost"}.}

\item{fn_dem_fsc}{File path for dem after removing single-cell pits.}

\item{...}{Additional arguments to be passed to functions to remove sinks.}
}
\value{
Returns a raster object containing the processed dem.
}
\description{
Sinks are removed from a DEM using one of several methods. The raster file
types supported are listed in \code{\link{Spatial_hydrology_functions}}.
}
\examples{
# Only proceed if Whitebox executable is installed
library(whitebox)
if (check_whitebox_binary()){
  library(raster)
  test_raster <- ch_volcano_raster()
  dem_raster_file <- tempfile(fileext = c(".tif"))
  no_sink_raster_file <- tempfile("no_sinks", fileext = c(".tif"))

  # write test raster to file
  writeRaster(test_raster, dem_raster_file, format = "GTiff")

  # remove sinks
  removed_sinks <- ch_wbt_removesinks(dem_raster_file, no_sink_raster_file, method = "fill")
} else {
  message("Examples not run as Whitebox executable not found")
}
}
\author{
Dan Moore
}
