% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{cardiac_failure_df}
\alias{cardiac_failure_df}
\title{Heart Failure Clinical Dataset}
\format{
A data frame with 299 observations and 13 variables:
\describe{
\item{age}{Patient age in years (numeric)}
\item{anaemia}{Presence of anaemia (integer: 0=no, 1=yes)}
\item{creatinine_phosphokinase}{Level of CPK enzyme in mcg/L (integer)}
\item{diabetes}{Presence of diabetes (integer: 0=no, 1=yes)}
\item{ejection_fraction}{Percentage of blood leaving heart (integer)}
\item{high_blood_pressure}{Presence of hypertension (integer: 0=no, 1=yes)}
\item{platelets}{Platelet count in kiloplatelets/mL (numeric)}
\item{serum_creatinine}{Level of serum creatinine in mg/dL (numeric)}
\item{serum_sodium}{Level of serum sodium in mEq/L (integer)}
\item{sex}{Patient sex (integer: 0=female, 1=male)}
\item{smoking}{Smoking status (integer: 0=no, 1=yes)}
\item{time}{Follow-up period in days (integer)}
\item{DEATH_EVENT}{Death during follow-up (integer: 0=no, 1=yes)}
}
}
\source{
Data taken from the SOPC package version 0.1.0
}
\usage{
data(cardiac_failure_df)
}
\description{
This dataset, cardiac_failure_df, is a data frame containing clinical data from
299 patients with heart failure. It includes 13 variables covering demographic
information, medical history, laboratory results, and mortality outcomes.
}
\details{
The dataset name has been kept as 'cardiac_failure_df' to avoid confusion with other
datasets in the R ecosystem. This naming convention helps distinguish this dataset
as part of the CardioDataSets package and assists users in identifying its specific
characteristics. The suffix 'df' indicates that the dataset is a standard data frame.
The original content has not been modified in any way.
}
