% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Dosepoint.R
\name{add_Dosepoint}
\alias{add_Dosepoint}
\title{Add Dosepoint in PML models}
\usage{
add_Dosepoint(
  PMLParametersSets,
  DosepointName = "A1",
  State = "Present",
  tlag = c(),
  bioavail = c(),
  duration = c(),
  rate = c(),
  PMLStructures = NULL
)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{DosepointName}{A character string giving the name of the Dosepoint.}

\item{State}{A character string giving the state of the Dosepoint, must be
one of "None", "Present", "Searched". Default is "Present".}

\item{tlag}{An optional parameter for the time lag. Can be an
\code{\link{StParm}} object, an \code{\link{Expression}} object, or a
character string (which will be converted to an Expression).}

\item{bioavail}{An optional parameter for bioavailability. Can be an
\code{\link{StParm}} object, an \code{\link{Expression}} object, or a
character string (which will be converted to an Expression).}

\item{duration}{An optional parameter for the duration of infusion. Can be an
\code{\link{StParm}} object, an \code{\link{Expression}} object, or a
character string (which will be converted to an Expression).}

\item{rate}{An optional parameter for the rate of infusion. Can be an
\code{\link{StParm}} object, an \code{\link{Expression}} object, or a
character string (which will be converted to an Expression).}

\item{PMLStructures}{Character or character vector specifying names of PML
structures in which the dosepoint statement will be modified. For the
naming convention of PMLStructures, see Details section of
\code{\link[=get_PMLParametersSets]{get_PMLParametersSets()}}.}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
Add Dosepoint in PML models
}
\examples{
PMLParametersSets <-
  create_ModelPK(CompartmentsNumber = c(1, 2, 3),
                 Absorption = c("First-Order"))

# modify dosepoint
PMLParametersSets <-
  modify_Dosepoint(PMLParametersSets,
                   DosepointName = "Aa",
                   tlag = StParm(StParmName = "Tlag",
                                 State = "Present"),
                   bioavail = StParm(StParmName = "F",
                                     State = "Present"))

# add dosepoint
PMLParametersSets <-
 add_Dosepoint(PMLParametersSets,
               DosepointName = "A1",
               bioavail = Expression("1 - F"),
               duration = Expression("Tlag"))

}
\seealso{
\code{\link[=list_Dosepoints]{list_Dosepoints()}}, \code{\link[=modify_Dosepoint]{modify_Dosepoint()}}

Functions used for Dosepoint specification: 
\code{\link{Dosepoint}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_Dosepoint}()}
}
\concept{Dosepoints}
