% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMLStructureCustom.R
\name{add_Spaces}
\alias{add_Spaces}
\title{Add Multiple Model Spaces to a PMLModels Object}
\usage{
add_Spaces(Spaces, NewSpaces, NewSpacesNames = character())
}
\arguments{
\item{Spaces}{A \code{PMLModels} object (a named list) representing the existing
collection of model spaces. Can be an empty list or a previously created
\code{PMLModels} object.}

\item{NewSpaces}{A list where each element is an internal representation of a
single model space (e.g., the list structure produced by \code{create_ModelPK}
or \code{create_CustomSpace}). If this list is named, these
names will be used unless overridden by \code{NewSpacesNames}.}

\item{NewSpacesNames}{An optional character vector providing explicit names for
the spaces listed in \code{NewSpaces}. If provided:
If omitted, the names attached to the \code{NewSpaces} list itself will be used.}
}
\value{
An updated \code{PMLModels} object (a named list) containing all the
original spaces plus all spaces from \code{NewSpaces}. The class "PMLModels"
is preserved.
}
\description{
Merges a list of new model spaces into an existing \code{PMLModels} object.
}
\details{
This function provides a general mechanism for combining collections of model
spaces.

Naming and Collision Handling:
This behavior differs from \code{\link[=add_CustomSpace]{add_CustomSpace()}}, which automatically renames
on collision. \code{add_Spaces} requires unique, non-colliding names for the merge.
}
\examples{
pk_model1 <-
  create_ModelPK(CompartmentsNumber = 1,
                 Absorption = "Intravenous")
pk_models2 <- create_ModelPK(CompartmentsNumber = c(2, 3),
                             Absorption = "First-Order")

# Combine two PMLModels objects (using names from pk_models2)
combined1 <- add_Spaces(pk_model1, pk_models2)
names(combined1)

# Combine using explicit new names
combined2 <-
  add_Spaces(pk_model1,
             pk_models2,
             NewSpacesNames = c("Model_A", "Model_B"))
names(combined2)

# Add a list containing a single custom space
custom_pml <- "test(){ fixef(p=1) }"
custom_space_list <-
  create_CustomSpace(custom_pml, "MyCustom")
combined3 <-
  add_Spaces(pk_model1, custom_space_list)
names(combined3)

}
\seealso{
\code{\link[=add_CustomSpace]{add_CustomSpace()}} for adding a single custom space with automatic renaming.
}
