% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_StParm.R
\name{remove_StParm}
\alias{remove_StParm}
\title{Remove structural parameter from PML models}
\usage{
remove_StParm(PMLParametersSets, StParmName, PMLStructures = NULL)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{StParmName}{character specifying the name for the structural parameter
to be removed.}

\item{PMLStructures}{Character or character vector specifying names of PML
structures from which the structural parameter will be removed. For the
naming convention of PMLStructures, see Details section of
\code{\link[=get_PMLParametersSets]{get_PMLParametersSets()}}.}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
Remove structural parameter from PML models
}
\details{
Please make sure that structural parameter to be removed is not
essential for the model. Usually the user does not need to remove
any structural parameter. The only case is related to structural parameters
in \code{\link[=Dosepoint]{Dosepoint()}}.
}
\examples{
PMLParametersSets <- get_PMLParametersSets(CompartmentsNumber = c(1, 2))

PMLParametersSetsDuration <-
 add_StParm(PMLParametersSets,
            StParmName = "Duration",
            State = "Searched",
            DosepointArgName = "duration")

PMLParametersSetsDuration1CptOnly <-
 remove_StParm(PMLParametersSetsDuration,
               StParmName = "Duration",
               PMLStructures = "PK2IVC")

}
\seealso{
\code{\link[=Dosepoint]{Dosepoint()}} \code{\link[=list_StParms]{list_StParms()}}

Functions used for StParm specification: 
\code{\link{StParm}()},
\code{\link{add_StParm}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_StParm}()},
\code{\link{modify_StParmCustom}()}
}
\concept{StParms}
