% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpc.r
\docType{class}
\name{NlmeObservationVar-class}
\alias{NlmeObservationVar-class}
\alias{NlmeObservationVar}
\title{Class initializer for NlmeObservationVar-class}
\arguments{
\item{name}{Name of observation variable}

\item{xaxis}{One of: T, TAD, PRED. If nothing is specified,
the user-specified name of axis is used.}

\item{binningMethod}{Method of binning: \code{"none"} (default),
\code{"KMEANS"}, \code{"CENTERS"}, \code{"BOUNDARIES"}}

\item{binningOption}{Centers or boundary values specified as numeric vector}

\item{stratifyColumns}{Categorical covariates (up to 3)
for simulation stratification (overrides stratifyColumns given
in NlmeVpcParams)}

\item{ygroup}{Values specifying the category right
boundaries (used for categorical observations only; useful for count)}

\item{quantilesValues}{Quantiles to be estimate for each x value (bin value) in each strata for the current
observable (internal quantiles)}

\item{quantilesSecondaryValues}{Quantiles to estimate for each internal quantile
(quantiles for quantile)}

\item{BQLasLLOQ}{Flag to replace BLQ values with the LLOQ value}
}
\description{
Describes an observation(observe,multi,...)
}
\examples{

var <- NlmeObservationVar(
  name = "Cobs",
  xaxis = "t",
  binningMethod = "none",
  quantilesValues = c(5, 50, 95)
)
}
\keyword{internal}
