% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CustomCovariates.R
\name{getDbDuringCovariateData}
\alias{getDbDuringCovariateData}
\title{Extracts covariates that occur during a cohort}
\usage{
getDbDuringCovariateData(
  connection,
  oracleTempSchema = NULL,
  cdmDatabaseSchema,
  cdmVersion = "5",
  cohortTable = "#cohort_person",
  rowIdField = "subject_id",
  aggregated = TRUE,
  cohortIds = c(-1),
  covariateSettings,
  minCharacterizationMean = 0,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  ...
)
}
\arguments{
\item{connection}{The database connection}

\item{oracleTempSchema}{The temp schema if using oracle}

\item{cdmDatabaseSchema}{The schema of the OMOP CDM data}

\item{cdmVersion}{version of the OMOP CDM data}

\item{cohortTable}{the table name that contains the target population cohort}

\item{rowIdField}{string representing the unique identifier in the target population cohort}

\item{aggregated}{whether the covariate should be aggregated}

\item{cohortIds}{cohort id for the target cohort}

\item{covariateSettings}{settings for the covariate cohorts and time periods}

\item{minCharacterizationMean}{the minimum value for a covariate to be extracted}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support temp tables.
To emulate temp tables, provide a schema with write privileges where temp tables
can be created}

\item{...}{additional arguments from FeatureExtraction}
}
\value{
A 'FeatureExtraction' covariateData object containing the during covariates based on user settings
}
\description{
Extracts covariates that occur during a cohort
}
\details{
The user specifies a what during covariates they want and this executes them using FE
}
\examples{

conDet <- exampleOmopConnectionDetails()
connection <- DatabaseConnector::connect(conDet)

settings <- createDuringCovariateSettings(
  useConditionOccurrenceDuring = TRUE,
  useConditionOccurrencePrimaryInpatientDuring = FALSE,
  useConditionEraDuring = FALSE,
  useConditionGroupEraDuring = FALSE
)

duringData <- getDbDuringCovariateData(
  connection <- connection,
  cdmDatabaseSchema = 'main',
  cohortIds = 1,
  covariateSettings = settings,
  cohortTable = 'cohort'
)

DatabaseConnector::disconnect(connection)

}
\seealso{
Other CovariateSetting: 
\code{\link{createDuringCovariateSettings}()}
}
\concept{CovariateSetting}
