% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{census_chile_2017_df}
\alias{census_chile_2017_df}
\title{Chilean Census Example Data (San Pablo Commune, 2017)}
\format{
A data frame with 7,512 observations and 60 variables:
\describe{
  \item{region}{Administrative region code}
  \item{provincia}{Province code}
  \item{comuna}{Commune code}
  \item{dc}{Census district code}
  \item{area}{Urban/rural area indicator}
  \item{zc_loc}{Census location zone}
  \item{id_zona_loc}{Location zone ID}
  \item{nviv}{Number of dwellings}
  \item{nhogar}{Number of households}
  \item{personan}{Person number}
  \item{p07}{Sex}
  \item{p08}{Relationship to head of household}
  \item{p09}{Age}
  \item{p10}{Place of birth (Chile or abroad)}
  \item{p10comuna}{Commune of birth}
  \item{p10pais}{Country of birth}
  \item{p11}{Last place of residence}
  \item{p11comuna}{Commune of last residence}
  \item{p11pais}{Country of last residence}
  \item{p12}{Place of residence in 2012}
  \item{p12comuna}{Commune of residence in 2012}
  \item{p12pais}{Country of residence in 2012}
  \item{p12a_llegada}{Year of arrival}
  \item{p12a_tramo}{Time range of arrival}
  \item{p13}{Health insurance}
  \item{p14}{Marital status}
  \item{p15}{Educational level}
  \item{p15a}{Currently attending school}
  \item{p16}{Employment status}
  \item{p16a}{Occupation type}
  \item{p16a_otro}{Other occupation (free text)}
  \item{p17}{Disability indicator}
  \item{p18}{Ethnic group}
  \item{p19}{Language spoken}
  \item{p20}{Language understood}
  \item{p21m}{Month of migration}
  \item{p21a}{Year of migration}
  \item{p10pais_grupo}{Grouped birth country}
  \item{p11pais_grupo}{Grouped last residence country}
  \item{p12pais_grupo}{Grouped 2012 residence country}
  \item{escolaridad}{Years of schooling}
  \item{p16a_grupo}{Grouped occupation}
  \item{region_15r}{Region code (15-region system)}
  \item{provincia_15r}{Province code (15-region system)}
  \item{comuna_15r}{Commune code (15-region system)}
  \item{p10comuna_15r}{Commune of birth (15-region system)}
  \item{p11comuna_15r}{Commune of last residence (15-region system)}
  \item{p12comuna_15r}{Commune of residence in 2012 (15-region system)}
  \item{geocode}{Geographical identifier}
  \item{p01}{Type of dwelling}
  \item{p02}{Dwelling condition}
  \item{p03a}{Material of exterior walls}
  \item{p03b}{Material of floor}
  \item{p03c}{Material of roof}
  \item{p04}{Number of rooms}
  \item{p05}{Number of bedrooms}
  \item{cant_hog}{Number of households in the dwelling}
  \item{cant_per}{Number of persons in the dwelling}
  \item{tipo_hogar}{Type of household}
  \item{tipo_operativo}{Census operation type}
}
}
\source{
Data taken from the ismtchile package version 2.1.5.
}
\usage{
data(census_chile_2017_df)
}
\description{
This dataset, census_chile_2017_df, is a data frame containing microdata from the 2017 Chilean census,
specifically from the commune of San Pablo. It was selected due to its relatively small size,
making it suitable for inclusion in CRAN and GitHub repositories. The dataset includes 7,512 observations
and 60 variables related to housing, households, individuals, migration, education, and geographic information.
All variable names and data values are in Spanish, as retrieved from the original source.
}
\details{
The dataset name has been kept as census_chile_2017_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ChileDataAPI package and assists users in identifying its specific characteristics.
The suffix df indicates that the dataset is a data frame. The original content has not been modified.
}
