% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableRelationshipIds.R
\name{associatedRelationshipIds}
\alias{associatedRelationshipIds}
\title{Get available relationships with concepts in a codelist}
\usage{
associatedRelationshipIds(
  x,
  cdm,
  standardConcept1 = "Standard",
  standardConcept2 = "Standard",
  domains1 = "Condition",
  domains2 = "Condition"
)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{standardConcept1}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}

\item{standardConcept2}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}

\item{domains1}{Character vector with one or more of the OMOP CDM domain. If NULL, all domains are considered.}

\item{domains2}{Character vector with one or more of the OMOP CDM domain. If NULL, all domains are considered.}
}
\value{
A character vector with unique concept relationship values.
}
\description{
Get available relationships with concepts in a codelist
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create CDM object
cdm <- mockCdmReference()


codelist <- newCodelist(list("codes1" = c(8479L, 4117795L),
                             "codes2" = c(8480L, 8600L, 8481L, 4189167L)))
associatedRelationshipIds(x = codelist, cdm = cdm,
                         standardConcept1 = c("Standard", "Non-standard", "Classification"),
                         standardConcept2 = c("Standard", "Non-standard", "Classification"),
                         domains1 = NULL,
                         domains2 = NULL)
}
}
