% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_bootstrap.R
\name{starting_locs}
\alias{starting_locs}
\title{Random Block Locations}
\usage{
starting_locs(N, l, k, boot_type = "moving")
}
\arguments{
\item{N}{The length of the observation window.}

\item{l}{The block length considered for bootstrap.}

\item{k}{The number of blocks considered for bootstrap.}

\item{boot_type}{What type of block bootstrap should be used, either 'moving' for moving block bootstrap or 'circular' for circular block bootstrap.}
}
\value{
A vector of length \code{k} whose values are random block locations.
}
\description{
This function performs random sampling to obtain random starting locations for block bootstrap.
}
\details{
This function performs random sampling to obtain random starting locations for block bootstrap.
If \code{type = 'moving'}, the set \eqn{\{1, \dots, N - \ell  + 1\}} is randomly sampled, with replacement, \eqn{k} times to obtain random block locations for moving block bootstrap.
If \code{type = 'circular'}, the set \eqn{\{1, \dots, N\}} is randomly sampled, with replacement, \eqn{k} times to obtain random block locations for moving block bootstrap.
}
\examples{
starting_locs(4, 2, 2)
}
\references{
Chapters 2.5 and 2.7 in Lahiri, S. N. (2003). Resampling Methods for Dependent Data. Springer. https://doi.org/10.1007/978-1-4757-3803-2

Künsch, H. R. (1989). The Jackknife and the Bootstrap for General Stationary Observations. The Annals of Statistics 17(3), 1217-1241. https://doi.org/10.1214/aos/1176347265

Politis, D. N. & Romano, J. P. (1991). A Circular Block-Resampling Procedure for Stationary Data. In R. LePage & L. Billard, eds, Exploring the Limits of Bootstrap, Wiley, 263-270.
}
