% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbExpect.R
\name{dbExpect}
\alias{dbExpect}
\title{Expected value of cell counts in DNA database comparison}
\usage{
dbExpect(
  probs,
  theta = 0,
  k = c(0, 0, 1),
  n = 1,
  r = 0,
  R = 0,
  round = FALSE,
  na = TRUE,
  vector = FALSE,
  collapse = FALSE,
  wildcard = FALSE,
  no.wildcard = NULL,
  rare.allele = FALSE,
  no.rare.allele = NULL
)
}
\arguments{
\item{probs}{List of vectors with allele probabilities for each locus}

\item{theta}{The coancestery coefficient}

\item{k}{The vector of identical-by-descent probabilities, k=(k2,k1,k0),
where for full-siblings k=c(1,2,1)/4. The default is k=c(0,0,1) refering to
unrelated individuals.}

\item{n}{Number of DNA profiles in the database}

\item{r}{The probability assigned to the rare alleles (see rare allele
matching). If a vector must be of same length as \code{probs}.}

\item{R}{The probability assigned to alleles shorter or longer than allelic
ladder (see rare allele matching). If a vector must be of length 1 or 2, and
if a list it must be same length as \code{probs}.}

\item{round}{Whether or not the results should be rounded or not}

\item{na}{Whether or not the off-elements should be returned as 0 or NA}

\item{vector}{Whether or not the result should be returned as a matrix or
vector. Note if 'collapse' is TRUE vector is ignored.}

\item{collapse}{Logical (default FALSE). If TRUE the (m,p)-matrix will be
collapased into a (2*m+p)-vector containing the total number of matching
alleles.}

\item{wildcard}{Should wildcards be used?}

\item{no.wildcard}{Should 'w' wildcards be used?}

\item{rare.allele}{Should rare allele matching be used?}

\item{no.rare.allele}{Should 'r' rare allele loci be used?}
}
\value{
Returns a matrix (or vector, see above) of expected cell counts.
}
\description{
Computes the expected number of cell counts when comparing DNA profiles in a
DNA database. For every pair of DNA profiles in a database the number of
matching and partial matching loci is recorded. A match is declared if the
two DNA profiles coincide for both alleles in a locus and a partial-match is
recorded if only one allele is shared between the profiles. With a total of
L loci the number of matching loci is 0,...,L and partial number of matches
is 0,...,L-m, where m is the number of matching loci.
}
\details{
Computes the expected cell counts using a recursion formula. See Tvedebrink
et al (2011) for details.
}
\examples{

  \dontrun{
  ## Simulate some allele frequencies:
  freqs <-  replicate(10, { g = rgamma(n=10,scale=4,shape=3); g/sum(g)},
              simplify=FALSE)
  ## Compute the expected number for a DB with 10000 profiles:
  dbExpect(freqs,theta=0,n=10000)
  } 

}
\references{
T Tvedebrink, PS Eriksen, J Curran, HS Mogensen, N Morling.
'Analysis of matches and partial-matches in Danish DNA reference profile
database'. Forensic Science International: Genetics, 2011.
}
\author{
James Curran and Torben Tvedebrink
}
