% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{package_build}
\alias{package_build}
\title{Pre-process, document and build a data package}
\usage{
package_build(
  packageName = NULL,
  vignettes = FALSE,
  deps = TRUE,
  install = FALSE,
  ...
)
}
\arguments{
\item{packageName}{\code{character} path to package source directory. Defaults to the current path when NULL.}

\item{vignettes}{\code{logical} specify whether to build vignettes. Default FALSE.}

\item{deps}{\code{logical} should we pass data objects into subsequent scripts? Default TRUE}

\item{install}{\code{logical} automatically install and load the package after building. Default FALSE}

\item{...}{additional arguments passed to \code{install.packages} when \code{install=TRUE}.}
}
\value{
Character vector. File path of the built package.
}
\description{
Combines the preprocessing, documentation, and build steps into one.
}
\details{
Note that if \code{package_build} returns an error when rendering an \code{.Rmd}
internally, but that same \code{.Rmd} can be run successfully manually using \code{rmarkdown::render},
then the following code facilitates debugging. Set \code{options(error = function(){ sink(); recover()})}
before running \code{package_build} . This will enable examination of the active function calls at the time of the error,
with output printed to the console rather than \code{knitr}'s default sink.
After debugging, evaluate \code{options(error = NULL)} to revert to default error handling.
See section "22.5.3 RMarkdown" at \url{ https://adv-r.hadley.nz/debugging.html} for more details.
}
\examples{
if(rmarkdown::pandoc_available()){
f <- tempdir()
f <- file.path(f,"foo.Rmd")
con <- file(f)
writeLines("```{r}\n tbl = data.frame(1:10) \n```\n",con=con)
close(con)
pname <- basename(tempfile())
datapackage_skeleton(name=pname,
   path=tempdir(),
   force = TRUE,
   r_object_names = "tbl",
   code_files = f)

package_build(file.path(tempdir(),pname), install = FALSE)
}
}
