/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaMenuPainter;
import ch.randelshofer.quaqua.QuaquaMenuPainterClient;
import ch.randelshofer.quaqua.color.PaintableColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class QuaquaMenuItemUI
extends BasicMenuItemUI
implements QuaquaMenuPainterClient {
    boolean fIsScreenMenuItem = false;
    int fType;
    static final int kPlain = 0;
    static final int kCheckBox = 1;
    static final int kRadioButton = 2;
    static final String[] sPropertyPrefixes = new String[]{"MenuItem", "CheckBoxMenuItem", "RadioButtonMenuItem"};

    QuaquaMenuItemUI(int type) {
        this.fType = type;
    }

    public static ComponentUI createUI(JComponent jcomponent) {
        int i = 0;
        if (jcomponent instanceof JCheckBoxMenuItem) {
            i = 1;
        } else if (jcomponent instanceof JRadioButtonMenuItem) {
            i = 2;
        }
        return new QuaquaMenuItemUI(i);
    }

    protected String getPropertyPrefix() {
        return sPropertyPrefixes[this.fType];
    }

    protected void updateListenersForScreenMenuItem() {
        this.setIsScreenMenu(true);
    }

    protected void setIsScreenMenu(boolean bool) {
        if (this.fIsScreenMenuItem != bool) {
            this.fIsScreenMenuItem = bool;
            if (this.fIsScreenMenuItem) {
                this.removeListeners();
            } else {
                this.addListeners();
            }
        }
    }

    protected void removeListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
    }

    protected void addListeners() {
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        QuaquaMenuPainter.getInstance().paintMenuItem(this, g, c, checkIcon, arrowIcon, background, foreground, this.disabledForeground, this.selectionForeground, defaultTextIconGap, this.acceleratorFont);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        return QuaquaMenuPainter.getInstance().getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap, this.acceleratorFont);
    }

    public void update(Graphics graphics, JComponent jcomponent) {
        this.paint(graphics, jcomponent);
    }

    public void paintBackground(Graphics g, JComponent component, int menuWidth, int menuHeight) {
        Color bgColor = this.selectionBackground;
        AbstractButton menuItem = (AbstractButton)component;
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        if (menuItem.isOpaque()) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                ((Graphics2D)g).setPaint(PaintableColor.getPaint(bgColor, component));
                g.fillRect(0, 0, menuWidth, menuHeight);
            } else {
                ((Graphics2D)g).setPaint(PaintableColor.getPaint(menuItem.getBackground(), component));
                g.fillRect(0, 0, menuWidth, menuHeight);
            }
            g.setColor(oldColor);
        }
    }
}

