/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.util.Vector;
import org.rosuda.ibase.MapSegmentEntry;
import org.rosuda.util.Tools;

public class MapSegment {
    Vector ents = new Vector();
    boolean isFirst = true;
    public double minX;
    public double minY;
    public double maxX;
    public double maxY;

    public void add(double[] dArray, double[] dArray2) {
        MapSegmentEntry mapSegmentEntry = new MapSegmentEntry(dArray, dArray2, false, true);
        this.add(mapSegmentEntry);
    }

    public void add(double[] dArray, double[] dArray2, boolean bl) {
        MapSegmentEntry mapSegmentEntry = new MapSegmentEntry(dArray, dArray2, bl, true);
        this.add(mapSegmentEntry);
    }

    public void add(double[] dArray, double[] dArray2, int n, int n2, boolean bl) {
        MapSegmentEntry mapSegmentEntry = new MapSegmentEntry(dArray, dArray2, n, n2, bl, true);
        this.add(mapSegmentEntry);
    }

    public void add(MapSegmentEntry mapSegmentEntry) {
        this.ents.addElement(mapSegmentEntry);
        if (mapSegmentEntry != null) {
            if (this.isFirst) {
                this.minX = mapSegmentEntry.minX;
                this.maxX = mapSegmentEntry.maxX;
                this.minY = mapSegmentEntry.minY;
                this.maxY = mapSegmentEntry.maxY;
                this.isFirst = false;
            } else {
                if (mapSegmentEntry.minX < this.minX) {
                    this.minX = mapSegmentEntry.minX;
                }
                if (mapSegmentEntry.minY < this.minY) {
                    this.minY = mapSegmentEntry.minY;
                }
                if (mapSegmentEntry.maxX > this.maxX) {
                    this.maxX = mapSegmentEntry.maxX;
                }
                if (mapSegmentEntry.maxY > this.maxY) {
                    this.maxY = mapSegmentEntry.maxY;
                }
            }
        }
    }

    public int count() {
        return this.ents.size();
    }

    public MapSegmentEntry at(int n) {
        return (MapSegmentEntry)this.ents.elementAt(n);
    }

    public int getSizeAt(int n) {
        MapSegmentEntry mapSegmentEntry = (MapSegmentEntry)this.ents.elementAt(n);
        return mapSegmentEntry == null ? 0 : mapSegmentEntry.xp.length;
    }

    public double[] getXat(int n) {
        MapSegmentEntry mapSegmentEntry = (MapSegmentEntry)this.ents.elementAt(n);
        return mapSegmentEntry == null ? null : mapSegmentEntry.xp;
    }

    public double[] getYat(int n) {
        MapSegmentEntry mapSegmentEntry = (MapSegmentEntry)this.ents.elementAt(n);
        return mapSegmentEntry == null ? null : mapSegmentEntry.yp;
    }

    public boolean isLakeAt(int n) {
        MapSegmentEntry mapSegmentEntry = (MapSegmentEntry)this.ents.elementAt(n);
        return mapSegmentEntry == null ? false : mapSegmentEntry.isLake;
    }

    public int[] getXtransAt(int n, double d, double d2, int n2) {
        MapSegmentEntry mapSegmentEntry = (MapSegmentEntry)this.ents.elementAt(n);
        if (mapSegmentEntry == null) {
            return null;
        }
        int[] nArray = new int[mapSegmentEntry.xp.length];
        for (int i = 0; i < mapSegmentEntry.xp.length; ++i) {
            nArray[i] = n2 + (int)((mapSegmentEntry.xp[i] + d2) * d);
        }
        return nArray;
    }

    public int[] getYtransAt(int n, double d, double d2, int n2) {
        MapSegmentEntry mapSegmentEntry = (MapSegmentEntry)this.ents.elementAt(n);
        if (mapSegmentEntry == null) {
            return null;
        }
        int[] nArray = new int[mapSegmentEntry.yp.length];
        for (int i = 0; i < mapSegmentEntry.yp.length; ++i) {
            nArray[i] = n2 + (int)((mapSegmentEntry.yp[i] + d2) * d);
        }
        return nArray;
    }

    public String toString() {
        return "Map segment (" + Tools.getDisplayableValue(this.minX) + "," + Tools.getDisplayableValue(this.minY) + ")-(" + Tools.getDisplayableValue(this.maxX) + "," + Tools.getDisplayableValue(this.maxY) + ")";
    }
}

