/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.PlotColor;
import org.rosuda.ibase.toolkit.PlotManager;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.Global;

public class PlotObject {
    public static final int CS_ABS = 0;
    public static final int CS_VAR = 1;
    public static final int CS_REL = 2;
    static final int INaN = Integer.MIN_VALUE;
    PlotManager pm;
    boolean visible = true;
    boolean clip = false;
    int coordX = 1;
    int coordY = 1;
    PlotColor cold;
    PlotColor colf;
    int layer = -1;

    public PlotObject(PlotManager plotManager) {
        this.pm = plotManager;
        plotManager.add(this);
    }

    public void dispose() {
        this.pm.rm(this);
        this.pm = null;
        this.cold = null;
        this.colf = null;
    }

    public void draw(PoGraSS poGraSS) {
    }

    public void setDrawColor(PlotColor plotColor) {
        this.cold = plotColor;
    }

    public void setFillColor(PlotColor plotColor) {
        this.colf = plotColor;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (Global.DEBUG > 0) {
            System.out.println("Setting visibility to \"" + bl + "\", was " + this.visible + " [" + this.toString() + "]");
        }
        this.visible = bl;
    }

    public void setCoordinates(int n) {
        this.coordX = this.coordY = n;
    }

    public void setCoordinates(int n, int n2) {
        this.coordX = n;
        this.coordY = n2;
    }

    public int getXPos(double d) {
        if (this.coordX == 0) {
            return (int)d;
        }
        Axis axis = this.pm.getXAxis();
        if (axis == null) {
            return 0;
        }
        return this.coordX == 1 ? axis.getValuePos(d) : axis.gBegin + (int)((double)axis.gLen * d);
    }

    public int getYPos(double d) {
        if (this.coordY == 0) {
            return (int)d;
        }
        Axis axis = this.pm.getYAxis();
        if (axis == null) {
            return 0;
        }
        return this.coordY == 1 ? axis.getValuePos(d) : axis.gBegin + (int)((double)axis.gLen * d);
    }

    public void setClip(boolean bl) {
        this.clip = bl;
    }

    public PlotColor gerDrawColor() {
        return this.cold;
    }

    public PlotColor gerFillColor() {
        return this.colf;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public int getLayer() {
        return this.layer;
    }

    public void update() {
        if (Global.DEBUG > 0) {
            System.out.println("[" + this.toString() + "] initiated update at layer " + this.layer);
        }
        this.pm.update(this.layer);
    }

    public String toString() {
        return "PlotObject(co=" + this.coordX + ":" + this.coordY + ",dc=" + (this.cold == null ? "none" : this.cold.toString()) + ",fc=" + (this.colf == null ? "none" : this.colf.toString()) + ")";
    }
}

