/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

final class MonitoredEval {
    volatile boolean done = false;
    volatile REXP result;
    int interval;
    int checkInterval;
    boolean ask;

    public MonitoredEval(int n, boolean bl) {
        this.checkInterval = this.interval = n;
        this.ask = bl;
    }

    protected void startMonitor() {
        int n = 0;
        while (true) {
            try {
                Thread.sleep(this.checkInterval);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (this.done) {
                return;
            }
            if (n + this.checkInterval < this.interval) {
                n += this.checkInterval;
                continue;
            }
            int n2 = this.ask ? JOptionPane.showConfirmDialog(null, "This R process is taking some time.\nWould you like to cancel it?", "Cancel R Process", 0) : 0;
            if (n2 == 0) {
                ((JRIEngine)JGR.getREngine()).getRni().rniStop(0);
                return;
            }
            n = 0;
        }
    }

    public REXP run(String string) {
        try {
            if (SwingUtilities.isEventDispatchThread() && this.ask) {
                final String string2 = string;
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            MonitoredEval.this.result = JGR.eval(string2);
                        }
                        catch (REngineException rEngineException) {
                            MonitoredEval.this.result = null;
                        }
                        catch (REXPMismatchException rEXPMismatchException) {
                            MonitoredEval.this.result = null;
                        }
                        MonitoredEval.this.done = true;
                    }
                }).start();
                this.checkInterval = 10;
                this.startMonitor();
            } else {
                new Thread(new Runnable(){

                    public void run() {
                        MonitoredEval.this.startMonitor();
                    }
                }).start();
                this.result = JGR.eval(string);
            }
            this.done = true;
            return this.result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void assign(String string, REXP rEXP) {
        if (SwingUtilities.isEventDispatchThread() && this.ask) {
            final String string2 = string;
            final REXP rEXP2 = rEXP;
            new Thread(new Runnable(){

                public void run() {
                    try {
                        JGR.getREngine().assign(string2, rEXP2);
                    }
                    catch (REngineException rEngineException) {
                        MonitoredEval.this.result = null;
                    }
                    catch (REXPMismatchException rEXPMismatchException) {
                        MonitoredEval.this.result = null;
                    }
                    MonitoredEval.this.done = true;
                }
            }).start();
            this.checkInterval = 10;
            this.startMonitor();
        } else {
            new Thread(new Runnable(){

                public void run() {
                    MonitoredEval.this.startMonitor();
                }
            }).start();
            try {
                JGR.getREngine().assign(string, rEXP);
                this.done = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

