/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.javaGD;

import java.awt.Graphics;
import org.rosuda.javaGD.JGDPanel;

public class JGDBufferedPanel
extends JGDPanel {
    public long lastSyncAttempt;
    public long lastPaint;
    public long syncDelay = 200L;
    public long refreshGranularity = 400L;
    public boolean updateDelayed = false;
    public boolean updateLocked = false;
    public Refresher ref = new Refresher(this);

    public JGDBufferedPanel(double d, double d2) {
        this((int)d, (int)d2);
    }

    public JGDBufferedPanel(int n, int n2) {
        super(n, n2);
        this.ref.start();
    }

    public void superPC(Graphics graphics) {
        super.paintComponent(graphics);
    }

    public void closeDisplay() {
        super.closeDisplay();
        if (this.ref != null) {
            this.ref.active = false;
        }
        this.ref = null;
    }

    public synchronized void syncDisplay(boolean bl) {
        if (!bl) {
            this.lastSyncAttempt = System.currentTimeMillis();
            this.updateLocked = true;
            return;
        }
        this.updateLocked = false;
        if (System.currentTimeMillis() - this.lastSyncAttempt > this.syncDelay) {
            this.repaint();
            this.updateDelayed = false;
        } else {
            this.updateDelayed = true;
        }
        this.lastSyncAttempt = System.currentTimeMillis();
    }

    public synchronized void paintComponent(Graphics graphics) {
        this.superPC(graphics);
        this.lastPaint = this.lastSyncAttempt = System.currentTimeMillis();
    }

    class Refresher
    extends Thread {
        JGDBufferedPanel c;
        boolean active;

        public Refresher(JGDBufferedPanel jGDBufferedPanel2) {
            this.c = jGDBufferedPanel2;
        }

        public void run() {
            this.active = true;
            while (this.active) {
                try {
                    Thread.sleep(JGDBufferedPanel.this.refreshGranularity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.active) break;
                if (!this.c.updateDelayed || this.c.updateLocked || System.currentTimeMillis() - this.c.lastSyncAttempt <= this.c.syncDelay) continue;
                this.c.syncDisplay(true);
            }
            this.c = null;
        }
    }
}

