% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patt_deep.R
\name{deep_complier_mod}
\alias{deep_complier_mod}
\title{Train complier model using deep neural learning through Tensorflow}
\usage{
deep_complier_mod(
  complier.formula,
  exp.data,
  treat.var,
  algorithm = "adam",
  hidden.layer = c(2, 2),
  hidden_activation = "relu",
  ID = NULL,
  epoch = 10,
  verbose = 1,
  batch_size = 32,
  validation_split = NULL,
  patience = NULL,
  dropout_rate = NULL
)
}
\arguments{
\item{complier.formula}{formula to fit compliance model (c ~ x) using complier variable and covariates}

\item{exp.data}{list object of experimental data.}

\item{treat.var}{string specifying the binary treatment variable}

\item{algorithm}{string for name of optimizer algorithm. Set to adam.
other optimization algorithms available are sgd, rprop, adagrad.}

\item{hidden.layer}{vector specifying the hidden layers and the number of neurons in each layer.}

\item{hidden_activation}{string or vector for activation function used for hidden layers. Defaults to "relu".}

\item{ID}{string for name of identifier variable.}

\item{epoch}{integer for number of epochs}

\item{verbose}{1 to display model training information and learning curve plot. 0 to suppress messages and plots.}

\item{batch_size}{integer for batch size to split the training set. Defaults to 32.}

\item{validation_split}{double for proportion of training data to be split for validation.}

\item{patience}{integer for number of epochs with no improvement after which training will be stopped.}

\item{dropout_rate}{double or vector for proportion of hidden layer to drop out.}
}
\value{
deep.complier.mod model object
}
\description{
Train model using group exposed to treatment with compliance as binary
outcome variable and covariates.
}
