% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockDrugExposure.R
\name{mockDrugExposure}
\alias{mockDrugExposure}
\title{Mock Drug exposure tables for ingredients of interest}
\usage{
mockDrugExposure(
  drug_exposure = NULL,
  concept_ancestor = NULL,
  concept_relationship = NULL,
  concept = NULL,
  drug_strength = NULL,
  ingredient_drug_records = NULL,
  drug_exposure_size = 100,
  patient_size = 50,
  person = NULL,
  observation_period = NULL,
  amount_val = c(NA, 100, 200, 300),
  den_val = c(1, 10, 100),
  amount_unit = c(8587, 8576, 9655),
  num_unit = c(8587, 8576, 9655),
  denom_unit = c(8587, 8576, 8505),
  num_val = c(1, 2, 3),
  seed = 1
)
}
\arguments{
\item{drug_exposure}{drug exposure table}

\item{concept_ancestor}{concept_ancestor table}

\item{concept_relationship}{concept_relationship table}

\item{concept}{concept table}

\item{drug_strength}{drug strength table}

\item{ingredient_drug_records}{modified drug exposure table having drug name}

\item{drug_exposure_size}{the sample size of the drug exposure table}

\item{patient_size}{the number of unique patients in the drug exposure table}

\item{person}{person table}

\item{observation_period}{observation_period table}

\item{amount_val}{vector of possible numeric amount value for the drug in the drug strength table}

\item{den_val}{vector of possible numeric denominator value for the drug in drug strength table}

\item{amount_unit}{vector of possible amount unit type drug strength table representing milligram, milliliter and microgram}

\item{num_unit}{vector of possible numerator unit type drug strength table representing milligram, milliliter and microgram}

\item{denom_unit}{vector of possible numerator unit type drug strength table representing milligram, milliliter and hour}

\item{num_val}{vector of possible numeric numerator denominator value drug strength table}

\item{seed}{seed to make results reproducible}
}
\value{
CDMConnector CDM reference object to duckdb database with mock data include  concept_ancestor, concept, drug_strength, drug_exposure tables
}
\description{
Mock Drug exposure tables for ingredients of interest
}
