% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.Hull}
\alias{plot.CD}
\alias{plot.PA}
\alias{plot.EKC}
\alias{plot.KGC}
\alias{plot.EFAkmeans}
\alias{plot.EFAhclust}
\alias{plot.NN}
\alias{plot.FF}
\alias{plot.CDF}
\alias{plot.EFAvote}
\alias{plot.EFAscreet}
\alias{plot.MAP}
\alias{plot.STOC}
\title{Plot Methods}
\usage{
\method{plot}{Hull}(x, ...)

\method{plot}{CD}(x, ...)

\method{plot}{PA}(x, ...)

\method{plot}{EKC}(x, ...)

\method{plot}{KGC}(x, ...)

\method{plot}{EFAkmeans}(x, ...)

\method{plot}{EFAhclust}(x, ...)

\method{plot}{NN}(x, ...)

\method{plot}{FF}(x, ...)

\method{plot}{CDF}(x, ...)

\method{plot}{EFAvote}(x, ...)

\method{plot}{EFAscreet}(x, ...)

\method{plot}{MAP}(x, ...)

\method{plot}{STOC}(x, ...)
}
\arguments{
\item{x}{An object of class \code{Hull}, \code{CD}, \code{PA}, \code{EKC},
\code{KGC}, \code{EFAkmeans}, \code{EFAhclust}, \code{NN}, \code{FF},
\code{CDF}, \code{EFAvote}, \code{EFAscreet}, \code{MAP},  or \code{STOC}.}

\item{...}{Additional arguments passed to the plotting functions.}
}
\value{
None. Plots are produced as side effects.
}
\description{
These `plot` methods for different results, including:
\itemize{
 \item Hull plot for \code{\link[EFAfactors]{Hull}} results.
 \item Comparison Data plot for \code{\link[EFAfactors]{CD}} results.
 \item Parallel Analysis plot for \code{\link[EFAfactors]{PA}} results.
 \item Empirical Kaiser Criterion for \code{\link[EFAfactors]{EKC}} results.
 \item Kaiser-Guttman Criterion for \code{\link[EFAfactors]{KGC}} results.
 \item K-means plot for \code{\link[EFAfactors]{EFAkmeans}} results.
 \item Hierarchical Clustering plot for \code{\link[EFAfactors]{EFAhclust}} results.
 \item pre-trained Neural Networks plot for \code{\link[EFAfactors]{NN}} results.
 \item Factor Forest for \code{\link[EFAfactors]{FF}} results.
 \item Comparison Data Forest plot for \code{\link[EFAfactors]{CDF}} results.
 \item Voting Method plot for \code{\link[EFAfactors]{EFAvote}} results.
 \item Scree Plot for \code{\link[EFAfactors]{EFAscreet}} results.
 \item Minimum Average Partial Test plot for \code{\link[EFAfactors]{MAP}} results.
 \item Scree Test Optimal Coordinate plot for \code{\link[EFAfactors]{STOC}} results.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{plot(Hull)}: Plot method for Hull objects

\item \code{plot(CD)}: Plot method for CD objects

\item \code{plot(PA)}: Plot method for PA objects

\item \code{plot(EKC)}: Plot method for EKC objects

\item \code{plot(KGC)}: Plot method for KGC objects

\item \code{plot(EFAkmeans)}: Plot method for EFAkmeans objects

\item \code{plot(EFAhclust)}: Plot method for EFAhclust objects

\item \code{plot(NN)}: Plot method for NN objects

\item \code{plot(FF)}: Plot method for FF objects

\item \code{plot(CDF)}: Plot method for CDF objects

\item \code{plot(EFAvote)}: Plot method for EFAvote objects

\item \code{plot(EFAscreet)}: Plot method for EFAscreet objects

\item \code{plot(MAP)}: Plot method for MAP objects

\item \code{plot(STOC)}: Plot method for STOC objects

}}
\seealso{
\code{\link[EFAfactors]{Hull}}, \code{\link[EFAfactors]{CD}}, \code{\link[EFAfactors]{PA}},
         \code{\link[EFAfactors]{EKC}}, \code{\link[EFAfactors]{KGC}}, \code{\link[EFAfactors]{EFAkmeans}},
         \code{\link[EFAfactors]{EFAhclust}}, \code{\link[EFAfactors]{NN}}, \code{\link[EFAfactors]{FF}},
         \code{\link[EFAfactors]{CDF}}, \code{\link[EFAfactors]{EFAvote}}, \code{\link[EFAfactors]{EFAscreet}},
         \code{\link[EFAfactors]{MAP}}, \code{\link[EFAfactors]{STOC}}
}
