% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_parameters.R
\name{estimate_parameters}
\alias{estimate_parameters}
\title{estimate_parameters}
\usage{
estimate_parameters(dat, tol)
}
\arguments{
\item{dat}{An (n + 1) x (m + 1) data frame of finite numeric elements (possibly except for row 1, columns 1 to m) containing observed input (columns 1 to m) and output (column m + 1) data of the original model.}

\item{tol}{A tolerance parameter of the golden section search algorithm used for minimizing the one-dimensional likelihood function (vector of length 1, finite positive numeric element).}
}
\value{
A list consisting of three elements: 1) estimate of the covariance at lag 0 of the data that result from the output-differenced model (Sigma; (m + 1) x (m + 1) matrix of numeric elements); 2) estimate of the only non-zero element of the negative covariance at lag 1 of the data that result from the output-differenced model (sigma_y^2; vector of length 1, numeric element); 3) estimate of the mean of the data that result from the output-differenced model (mu; (m + 1) x 1 matrix of numeric elements).
}
\description{
Calculates maximum likelihood estimates of the statistical measures of the output-differenced version of the single-output cumulative structural equation model with an additive-noise output measurement equation and assumptions of normality and independence.
}
\examples{
set.seed(1)

m <- 4
k <- 2

L <- matrix(runif((m + 1) * k, min = -10, max = 10), nrow = m + 1)
sigma <- matrix(runif(m + 2, min = 0, max = 10), nrow = m + 2)
mu <- matrix(runif(m + 1, min = -10, max = 10), nrow = m + 1)

data <- generate_data(100, L, sigma, mu)

estimate_parameters(data, 0.00001)

}
\references{
Leonidas Sakalauskas, Vytautas Dulskis, & Darius Plikynas (2024). A Technique for Efficient Estimation of Dynamic Structural Equation Models: A Case Study. Structural Equation Modeling: A Multidisciplinary Journal, 31(4), 635-650. DOI: 10.1080/10705511.2023.2282378
}
