% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{aggr.fbms_predict}
\alias{aggr.fbms_predict}
\title{Access Aggregated Predictions}
\usage{
\method{aggr}{fbms_predict}(object, ...)
}
\arguments{
\item{object}{Object of class "fbms_predict".}

\item{...}{Additional arguments (ignored).}
}
\value{
List containing aggregated mean and quantiles.
}
\description{
Extracts the aggregated predictions (mean and quantiles) from an FBMS prediction object.
}
\examples{
\donttest{
data(exoplanet)
model <- fbms(semimajoraxis ~ ., data = exoplanet)
pred <- predict(model, exoplanet[51:60, -1])
aggr(pred)
}
}
