% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{compute_effects}
\alias{compute_effects}
\title{Compute Effects for Specified Covariates Using a Fitted Model}
\usage{
compute_effects(object, labels, quantiles = c(0.025, 0.5, 0.975))
}
\arguments{
\item{object}{A fitted model object, typically the result of a regression or predictive modeling.}

\item{labels}{A vector of labels for which effects are to be computed.}

\item{quantiles}{A numeric vector specifying the quantiles to be calculated. Default is c(0.025, 0.5, 0.975).}
}
\value{
A matrix of treatment effects for the specified labels, with rows corresponding to labels and columns to quantiles.
}
\description{
This function computes model averaged effects for specified covariates using a fitted model object.
The effects are expected change in the BMA linear predictor having an increase of the corresponding covariate by one unit, while other covariates are fixed to 0.
Users can provide custom labels and specify quantiles for the computation of effects.
}
\examples{

data <- data.frame(matrix(rnorm(600), 100))
result <- mjmcmc.parallel(runs = 2, 
cores = 1, 
y = matrix(rnorm(100), 100),
x = data, 
loglik.pi = gaussian.loglik)
compute_effects(result,labels = names(data))

}
\seealso{
\code{\link{predict}}
}
