% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{diagn_plot}
\alias{diagn_plot}
\title{Plot Convergence Diagnostics for GMJMCMC or GMJMCMC Merged Results}
\usage{
diagn_plot(
  res,
  FUN = median,
  conf = 0.95,
  burnin = 0,
  window = 5,
  ylim = NULL,
  ...
)
}
\arguments{
\item{res}{Object of class \code{gmjmcmc} or \code{gmjmcmc_merged} containing results from a GMJMCMC run or merged runs.}

\item{FUN}{Function to compute summary statistics (e.g., \code{median}, \code{mean}). Default is \code{median}.}

\item{conf}{Numeric; confidence level for intervals (e.g., 0.95 for 95\%). Default is 0.95.}

\item{burnin}{Integer; number of initial populations to skip. Default is 0.}

\item{window}{Integer; size of the sliding window for computing standard deviation. Default is 5.}

\item{ylim}{Numeric vector; y-axis limits for the plot. If \code{NULL}, computed from confidence intervals.}

\item{...}{Additional graphical parameters passed to \code{plot} and \code{lines} (e.g., \code{col}, \code{lwd}, \code{lty}, \code{main}, \code{xlab}, \code{ylab}).}
}
\value{
Returns \code{invisible(NULL)}. The function is called for its side effect of producing a plot.
}
\description{
Plots the convergence of summary statistics (e.g., median, mean) of log posteriors or marginal likelihoods
over populations for a GMJMCMC or GMJMCMC merged result object, with confidence intervals.
}
\examples{
data(exoplanet)
result <- fbms(semimajoraxis ~ ., data = exoplanet, method = "gmjmcmc", transforms = c("sin"))
diagn_plot(result, FUN = median, conf = 0.95, main = "Convergence Plot")

}
