% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predquantiles.fbms_predict}
\alias{predquantiles.fbms_predict}
\title{Access Quantile Predictions}
\usage{
\method{predquantiles}{fbms_predict}(object, ...)
}
\arguments{
\item{object}{Object of class "fbms_predict".}

\item{...}{Additional arguments (ignored).}
}
\value{
Matrix of quantile predictions, or NULL if not available.
}
\description{
Extracts the quantile predictions from an FBMS prediction object.
}
\examples{
\donttest{
data(exoplanet)
model <- fbms(semimajoraxis ~ ., data = exoplanet, method = "mjmcmc")
pred <- predict(model, exoplanet[51:60, -1])
predquantiles(pred)
}
}
