% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fftrees_cuerank.R
\name{fftrees_cuerank}
\alias{fftrees_cuerank}
\title{Calculate thresholds that optimize some statistic (goal) for cues in data}
\usage{
fftrees_cuerank(x = NULL, newdata = NULL, data = "train", rounding = NULL)
}
\arguments{
\item{x}{An \code{FFTrees} object.}

\item{newdata}{A dataset with cues to be ranked (as data frame).}

\item{data}{The type of data with cues to be ranked (as character: \code{'train'}, \code{'test'}, or \code{'dynamic'}).
Default: \code{data = 'train'}.}

\item{rounding}{integer. An integer value indicating the decimal digit
to which non-integer numeric cue thresholds are to be rounded.
Default: \code{rounding = NULL} (i.e., no rounding).}
}
\value{
A modified \code{FFTrees} object (with cue rank information
for the current \code{data} type in \code{x$cues$stats}).
}
\description{
\code{fftrees_cuerank} takes an \code{FFTrees} object \code{x} and
optimizes its \code{goal.threshold} (from \code{x$params}) for all cues in
\code{newdata} (of type \code{data}).
}
\details{
\code{fftrees_cuerank} creates a data frame \code{cuerank_df}
that is added to \code{x$cues$stats}.

Note that the cue directions and thresholds computed by \strong{FFTrees}
always predict positive criterion values (i.e., \code{TRUE} or signal,
rather than \code{FALSE} or noise).
Using these thresholds for negative exits (i.e., for predicting instances of
\code{FALSE} or noise) usually requires a reversal (e.g., negating cue direction).

\code{fftrees_cuerank} is called (twice) by the \code{fftrees_grow_fan} algorithm
to grow fast-and-frugal trees (FFTs).
}
