% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_sim_mtpi2.R
\name{run_sim_mtpi2}
\alias{run_sim_mtpi2}
\title{Simulations for the mTPI2 design.}
\usage{
run_sim_mtpi2(p.true,
                     mtd.true,
                     pT,
                     EI,
                     ncohort,
                     cohortsize = 3,
                     startdose = 1,
                     DU.pp = 0.95,
                     n.earlystop = 100,
                     ntrial = 1000,
                     seed = 6)
}
\arguments{
\item{p.true}{a vector or matrix containing the true toxicity probabilities of the investigational dose levels.}

\item{mtd.true}{a numeric value or a vector which specifies the true MTD.}

\item{pT}{a numeric value; the target DLT rate.}

\item{EI}{a vector which specifies the equivalence interval (EI).}

\item{ncohort}{a numeric value; the total number of cohorts.}

\item{cohortsize}{a numeric value; the cohort size.}

\item{startdose}{a numeric value; the starting dose level for the trial.}

\item{DU.pp}{a numeric value; the cutoff to remove an overly toxic dose for safety.
We recommend the default value of (\code{DU.pp=0.95}) for general use.}

\item{n.earlystop}{a numeric value; the early stopping parameter. If the number of participants
treated at the current dose reaches \code{n.earlystop},
stop the trial and select the MTD based on the observed data.
The default value \code{n.earlystop=100} essentially turns
off this type of early stopping.}

\item{ntrial}{a numeric value; the total number of simulated trials.}

\item{seed}{a numeric value; the random seed for simulation.}
}
\value{
\code{run_sim_mtpi2()} returns:

(1) a dataframe (\code{$selection}) with each column showing:
       the numbered index for each scenarios specified,
       the name of the design,
       the selection percentage at each dose level,
       the percentage of early stopping without selecting the MTD,
       the percentage of overdosing selection (POS),
       the percentage of correct selection (PCS),
       the percentage of underdosing selection (PUS),
       the numbered index for the true MTD, respectively.

(2) a dataframe (\code{$allocation}) with each column showing:
       the numbered index for each scenarios specified,
       the name of the design,
       the number of participants treated at each dose level,
       the average number of participants treated,
       the percentage of overdosing assignment (POA),
       the percentage of correct assignment (PCA),
       the percentage of underdosing assignment (PUA),
       the numbered index for the true MTD, respectively.

(3) a list (\code{$setup}) containing user input parameters, such as pT, EI, nparticipants, etc.
}
\description{
Conduct computer simulations for the mTPI2 design.
}
\details{
Denote the current dose \eqn{d}. Let \eqn{n_d} and \eqn{y_d} represent the
          number of participants treated at dose \eqn{d} and the number of participants
          experienced DLT, respectively. Let \eqn{p_d} be the toxicity probability at
          dose \eqn{d}. Also, denote \eqn{\frac{y_d}{n_d}} the observed toxicity rate
          at the current dose.

          The mTPI2 design divides the probability of DLT into equal-width intervals:
          underdosing, target dosing, and overdosing. Utilizing a  Bayesian model, mTPI-2
          updates the posterior probability estimates of DLTs. If the interval which maximizes
          the posterior probability is among the underdosing intervals, the decision is to
          escalate to the next higher dose; if the interval which maximizes the posterior
          probability is the target dosing interval, the decision is to stay at the current dose;
          if the interval which maximizes the posterior probability is among the overdosing intervals,
          the decision is to to de-escalate to the next lower dose.

          Also, the mTPI2 design includes a dose exclusion rule. Let \eqn{p_T} represents
          the pT DLT rate. If \eqn{Pr(p_d > p_T | y_d , n_d ) > 0.95}, dose \eqn{d}
          and those higher than \eqn{d} are removed from the trial since they are deemed
          excessively toxic.

          The mTPI2 design has two early stopping rules: (1) stop the trial if the lowest
         dose is eliminated due to toxicity, and no dose should be selected as the MTD; and
         (2) stop the trial and select the MTD if the number of participants treated at the current
         dose reaches \code{n.earlystop}.
}
\examples{
run_sim_mtpi2(p.true = c(0.25, 0.41, 0.45, 0.49, 0.53),
              mtd.true = c(1,0,0,0,0),
              pT = 0.25,
              EI = c(0.15,0.35),
              ncohort = 9,
              cohortsize = 3,
              startdose = 1,
              DU.pp = 0.95,
              n.earlystop = 100,
              ntrial = 1000,
              seed = 6)
}
\references{
Guo, W., Liu, S., & Yin, G. (2017). A more efficient Bayesian model for oncology dose-finding
trials with toxicity probability interval. Clinical Trials, 14(1), 16-26.
}
