% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CES.R
\name{CES}
\alias{CES}
\title{CES Function}
\usage{
CES(sigma = 1 - 1/es, alpha, beta, x, theta = rep(1, length(beta)), es = NA)
}
\arguments{
\item{sigma}{a scalar not greater than one.}

\item{alpha}{a nonnegative scalar.}

\item{beta}{a nonnegative n-vector.}

\item{x}{a nonnegative n-vector consisting of the inputs.}

\item{theta}{the all-ones n-vector (default) or a positive n-vector.}

\item{es}{the elasticity of substitution. If es is not NA, the value of sigma (i.e. 1 - 1 / es) will be ignored.}
}
\value{
A scalar indicating the output or utility level.
}
\description{
CES function, e.g. alpha * (beta1 * (x1 / theta1)^sigma + beta2 * (x2 / theta2)^sigma)^(1 / sigma).
}
\examples{
\donttest{
CES(0.5, 1, c(0.4, 0.6), c(1, 1), c(0.4, 0.6))
CES(0.5, 1, c(0.4, 0.6), c(1, 2))
}

}
