% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_regression_summary.R
\name{flex_regression_summary}
\alias{flex_regression_summary}
\title{flex_regression_summary function}
\usage{
flex_regression_summary(
  regression_data,
  interactive = TRUE,
  user_size_breaks = cut(regression_data$p_value, breaks = c(0, 0.01, 0.05, 0.1, 1),
    labels = c("< 0.01", "0.05", "0.1", "1"), include.lowest = TRUE),
  user_legend_break_sizes = c(12, 10, 8, 7),
  user_geom_tile = geom_tile(color = "white", fill = "white", size = 5),
  user_geom_point = geom_point(shape = 22, color = "white", stroke = 0),
  user_gradient_bar = scale_fill_gradientn(colours = c("red4", "white", "steelblue4"),
    limit = c(-max(abs(regression_data$estimate)) - 0.05,
    max(abs(regression_data$estimate)) + 0.05), guide = guide_colorbar(title =
    "Estimate", label.position = "right", barwidth = 1, barheight = 5, title.position =
    "top", order = 1)),
  user_geom_text = list(geom_text(data = subset(regression_data, (p_value <= 0.01)),
    aes(label = "**"), size = 6, vjust = 0.5, hjust = 0.5, show.legend = FALSE, color =
    "white", fontface = "bold"), geom_text(data = subset(regression_data, (p_value <=
    0.05 & p_value > 0.01)), aes(label = "*"), size = 6, vjust = 0.5, hjust = 0.5,
    show.legend = FALSE, color = "white", fontface = "bold")),
  user_theme = theme_minimal(),
  user_theme_specs = theme(axis.text.x = element_text(angle = 45, hjust = 1, vjust = 1,
    size = 15, colour = "black"), axis.text.y = element_text(size = 15), axis.title.y =
    element_text(size = 15), axis.title.x = element_text(size = 15), text =
    element_text(family = "serif"), legend.text = element_text(size = 15), legend.title =
    element_text(size = 15), legend.key.width = unit(0.01, "cm"), legend.key.height =
    unit(0.01, "cm"), legend.box = "horizontal", legend.spacing.y = unit(0.5, "cm"),
    legend.position = "right", legend.box.margin = margin(b = 15, 
     t = -20, l = 5, r
    = 5), legend.box.just = ("bottom"), plot.margin = margin(b = 5, t = 20, l = 5, r =
    5)),
  user_labs = labs(x = "x variable", y = "y variable", fill = "Estimate", size =
    "p value"),
  user_tooltip = list("Estimate: ", "p-value: "),
  user_size_legend_guides = guides(size = guide_legend(reverse = FALSE, label.position =
    "right", title.position = "top", override.aes = list(colour = "grey", shape = 15,
    fill = "white", size = user_legend_break_sizes - 3)))
)
}
\arguments{
\item{regression_data}{A dataframe containing the variables \code{x_var}, \code{y_var}, \code{estimate},
and \code{p_value} which represent the horizontal axis component, vertical axis component,
regression coefficient estimates, and their corresponding p-values, respectively.}

\item{interactive}{Logical, if TRUE returns an interactive plotly object, otherwise returns a ggplot object.}

\item{user_size_breaks}{Factor levels for breaking down the p-value into intervals. Default is
predefined intervals at p < 0.01, 0.05, 0.1, and 1.}

\item{user_legend_break_sizes}{A numeric vector indicating the sizes of points in the legend, corresponding
to the p-value intervals.}

\item{user_geom_tile}{Custom ggplot2 geom_tile layer, allows customization of tile appearance.}

\item{user_geom_point}{Custom ggplot2 geom_point layer, allows customization of point markers.}

\item{user_gradient_bar}{Custom ggplot2 scale_fill_gradientn for coloring the tiles based on the estimates.}

\item{user_geom_text}{List of custom ggplot2 geom_text layers for adding text annotations based on significance.}

\item{user_theme}{Custom ggplot2 theme, allows overriding the default minimal theme.}

\item{user_theme_specs}{Custom modifications to the default or user-specified theme.}

\item{user_labs}{Custom ggplot2 labs function for setting axis and legend titles.}

\item{user_tooltip}{A list containing tooltip strings for interactive plots.}

\item{user_size_legend_guides}{Custom ggplot2 guides for the size aesthetic in the legend.}
}
\value{
A ggplot or plotly object depending on the \code{interactive} argument.
}
\description{
This function creates a flexible regression summary plot with customization options for
interactivity, p-value intervals, legend sizes, color gradients, and more. It supports both
ggplot2 and plotly outputs for static and interactive visualizations, respectively.
}
\examples{
library(ggplot2)
library(plotly)
library(dplyr)
library(nortest)
library(ggforce)
library(reshape2)
library(gridExtra)
library(grid)
library(cowplot)
# Default usage
flex_regression_summary(example_data10)

# Custom p-value intervals and annotations
flex_regression_summary(example_data10, user_size_breaks = cut(example_data10$p_value,
                       breaks = c(0, 0.05, 1), labels = c("< 0.05", "1"), include.lowest = TRUE),
                        user_legend_break_sizes = c(12, 8), 
                        user_geom_text = list(geom_text(data = subset(example_data10, 
                                              (p_value <= 0.05)),
                                aes(label = "sig"),
                                size = 4, vjust = 0.5, hjust = 0.5,
                                color = "black",
                                fontface = "italic")))

# Custom formatting and gradient colors
flex_regression_summary(example_data10, interactive = FALSE, 
user_geom_point = geom_point(shape = 25, 
color = "white", stroke = 0),
                       user_gradient_bar = scale_fill_gradientn(colours = c("purple4", 
                       "white", "green4")))
}
