% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRAB_Simu.R
\name{GRAB.SimubVec}
\alias{GRAB.SimubVec}
\title{Simulate random effects based on family structure}
\usage{
GRAB.SimubVec(nSub, nFam, FamMode, tau)
}
\arguments{
\item{nSub}{Number of unrelated subjects. If 0, all subjects are related.}

\item{nFam}{Number of families. If 0, all subjects are unrelated.}

\item{FamMode}{Family structure: "4-members", "10-members", or "20-members".
See \code{\link{GRAB.SimuGMat}} for pedigree details.}

\item{tau}{Variance component for random effects.}
}
\value{
Data frame with columns:
\describe{
\item{IID}{Subject identifiers.}
\item{bVec}{Random effect values following appropriate correlation structure.}
}
}
\description{
Generates random effect vectors (bVec) that account for family relationships
through kinship-based correlation structures.
}
\details{
For related subjects, random effects follow a multivariate normal distribution
with covariance proportional to kinship coefficients. For unrelated subjects,
effects are independent normal random variables.
}
