% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPAmix.R
\name{fitNullModel.SPAmix}
\alias{fitNullModel.SPAmix}
\title{Fit a SPAmix null model from a survival response (\code{Surv}) with
covariates or from precomputed residuals. Principal components (PCs) named
in \code{control$PC_columns} are extracted; residual outliers are detected
using an IQR rule with adjustable multiplier and stored for SPA testing.}
\usage{
fitNullModel.SPAmix(response, designMat, subjData, control, ...)
}
\arguments{
\item{response}{Either a \code{survival::Surv} object (time-to-event data)
or a numeric residual vector/matrix with class \code{"Residual"}.}

\item{designMat}{Numeric matrix (n x p) of covariates; must include the PC
columns specified in \code{control$PC_columns}.}

\item{subjData}{Vector of subject IDs aligned with rows of \code{designMat}
and \code{response}.}

\item{control}{List of options. Required element: \code{PC_columns}, a
single comma-separated string of PC column names (e.g.
\code{"PC1,PC2,PC3,PC4"}). \code{OutlierRatio}.}

\item{...}{Extra arguments passed to \code{survival::coxph} when
\code{response} is \code{Surv}.}
}
\value{
A list of class \code{"SPAmix_NULL_Model"} containing:
\describe{
\item{resid}{Residual matrix (n x k)}
\item{N}{Number of subjects}
\item{yVec}{Response vector (event indicator for survival models)}
\item{PCs}{Selected principal component columns}
\item{nPheno}{Number of phenotypes (columns of residuals)}
\item{outLierList}{List of per-phenotype indices (0-based) and residual
subsets for outlier/non-outlier strata}
}
}
\description{
Fit a SPAmix null model from a survival response (\code{Surv}) with
covariates or from precomputed residuals. Principal components (PCs) named
in \code{control$PC_columns} are extracted; residual outliers are detected
using an IQR rule with adjustable multiplier and stored for SPA testing.
}
\details{
If \code{response} is \code{Surv}, a Cox model is fit and martingale
residuals are used. If \code{response} is \code{Residual}, its values are
used directly. Outliers per phenotype are defined by
\code{[Q1 - r*IQR, Q3 + r*IQR]} with \code{r = OutlierRatio}; if none are
found, \code{r} is iteratively reduced by 20\% until at least one appears.
}
\keyword{internal}
