% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\name{sf}
\alias{sf}
\title{Log rank test for non-inferiority trial}
\usage{
sf(event, status, delta0, group, experiment, control)
}
\arguments{
\item{event}{event time vector from person level trial data.}

\item{status}{numeric vector indicating the status of event from person level trial data.}

\item{delta0}{Non-inferiority margin.}

\item{group}{group string vector indicating the assignment of patients into control or experimental group.}

\item{experiment}{name of experimental group as character string.}

\item{control}{name of control group as character string.}
}
\value{
Returns the value of score statistic.
}
\description{
Calculates the score function of the log rank test for non-inferiority trial
}
\examples{
time<-c(20,65,12,50,58,65,45,44)
event<-c(1,0,0,0,1,1,1,1)
group<-c(rep("exp",4),rep("cont",4))
gg<-sf(event=time,status=event,delta0=1.3,group=group,experiment="exp",control="cont")
}
\author{
Tushar Patni, Yimei Li and Jianrong Wu.
}
