% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HandTill2001-package.R
\docType{package}
\name{HandTill2001-package}
\alias{HandTill2001-package}
\alias{HandTill2001}
\title{Multiple Class Area under ROC Curve}
\description{
A very lean package implementing merely \eqn{M} given by \cite{Hand and Till
(2001)}, Eq. (7).
}
\details{
\eqn{M} given by \cite{Hand and Till (2001)} defines a multiple class
version of the area under curve of the receiver operating characteristic.
}
\examples{

library(HandTill2001)
data(ht01.multipleclass)
auc(
  multcap(
    response = ht01.multipleclass$observed,
    predicted = as.matrix(ht01.multipleclass[, levels(ht01.multipleclass$observed)])
  )
)
}
\references{
\cite{David J. Hand and Robert J. Till (2001). A Simple
Generalisation of the Area Under the ROC Curve for Multiple Class
Classification Problems. \emph{Machine Learning} \bold{45}(2), p. 171--186.
DOI:
\doi{10.1023/A:1010920819831}}.
}
\seealso{
\code{help(package="HandTill2001")}, especially
\code{\link[=auc-methods]{?HandTill2001::auc}}; various packages that calculate
binary class AUC (\code{\link[ROCR:performance]{ROCR}}) or multiple class AUC
(pROC, \code{\link[caTools:caTools-package]{caTools}}).
}
\author{
\strong{Maintainer}: Andreas Dominik Cullmann \email{fvafrcu@mailbox.org}

}
\keyword{AUC}
\keyword{ROC}
