% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling_dataset_issues.R,
%   R/wrangling_dataset_labels.R, R/wrangling_dataset_milestones.R
\name{get_issues}
\alias{get_issues}
\alias{get_labels}
\alias{get_milestones}
\title{Retrieve information from the issues of GitHub}
\usage{
get_issues(
  source = c("local", "online"),
  dataset_dir = getOption("IssueTrackeR.dataset.dir"),
  dataset_name = "open_issues.yaml",
  repo = getOption("IssueTrackeR.repo"),
  owner = getOption("IssueTrackeR.owner"),
  state = c("open", "closed", "all"),
  verbose = TRUE
)

get_labels(
  source = c("local", "online"),
  dataset_dir = getOption("IssueTrackeR.dataset.dir"),
  dataset_name = "list_labels.yaml",
  repo = getOption("IssueTrackeR.repo"),
  owner = getOption("IssueTrackeR.owner"),
  verbose = TRUE
)

get_milestones(
  source = c("local", "online"),
  dataset_dir = getOption("IssueTrackeR.dataset.dir"),
  dataset_name = "list_milestones.yaml",
  repo = getOption("IssueTrackeR.repo"),
  owner = getOption("IssueTrackeR.owner"),
  state = c("open", "closed", "all"),
  verbose = TRUE
)
}
\arguments{
\item{source}{a character string that is either \code{"online"} if you want
to fetch information from GitHub or \code{"local"} (by default) if you want
to fetch information locally.}

\item{dataset_dir}{A character string specifying the path which contains the
datasets (only taken into account if \code{source} is set to \code{"local"}).
Defaults to the package option \code{IssueTrackeR.dataset.dir}.}

\item{dataset_name}{A character string specifying the name of the datasets
which will be written (only taken into account if \code{source} is set to
\code{"local"}).
Defaults to \code{"open_issues.yaml"}.}

\item{repo}{A character string specifying the GitHub repository name (only
taken into account if \code{source} is set to \code{"online"}).
Defaults to the package option \code{IssueTrackeR.repo}.}

\item{owner}{A character string specifying the GitHub owner (only taken
into account if \code{source} is set to \code{"online"}).
Defaults to the package option \code{IssueTrackeR.owner}.}

\item{state}{a character string that is either \code{"open"} (by default) if
you want to fetch only open issues from GitHub, \code{"closed"} if you want
to fetch only closed issues from GitHub or \code{"all"} if you want to fetch
all issues from GitHub (closed and open).
Only taken into account if \code{source} is set to \code{"online"}.}

\item{verbose}{A logical value indicating whether to print additional
information. Default is \code{TRUE}.}
}
\value{
The function \code{get_issues} returns an object of class \code{IssuesTB}. It
is a list composed by object of class \code{IssueTB}. An object of class
\code{IssueTB} represents an issue with simpler structure (with number,
title, body and labels).

The function \code{get_labels} returns a list representing labels with
simpler structure (with name, description, colour).

The function \code{get_milestones} returns a list representing milestones
with simpler structure (with title, description and due_on).
}
\description{
use \code{\link[gh]{gh}} to ask the API of GitHub and et a list of issues
with their labels and milestones.
}
\details{
The functions of get type are useful to retrieve object related to issues
from GitHub. So it's possible to retrieve issues, labels and milestones.

The defaults value for the argument \code{dataset_name} depends on the
function:
\itemize{
\item defaults is \code{"list_issues.yaml"} for \code{get_issues()}
\item defaults is \code{"list_milestones.yaml"} for \code{get_milestones()}
\item defaults is \code{"list_labels.yaml"} for \code{get_labels()}
}
}
\examples{

\dontrun{
# From online

issues <- get_issues(source = "online", owner = "rjdverse", repo = NULL)
issues <- get_issues(source = "online")
print(issues)

labels <- get_labels(source = "online")
print(labels)

milestones <- get_milestones(source = "online")
print(milestones)
}

# From local

path <- system.file("data_issues", package = "IssueTrackeR")
issues <- get_issues(
    source = "local",
    dataset_dir = path,
    dataset_name = "open_issues.yaml"
)
milestones <- get_milestones(
    source = "local",
    dataset_dir = path,
    dataset_name = "list_milestones.yaml"
)
labels <- get_labels(
    source = "local",
    dataset_dir = path,
    dataset_name = "list_labels.yaml"
)
}
