% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemrest_core.R
\name{itemrest}
\alias{itemrest}
\title{Evaluate Item Removal Strategies for Exploratory Factor Analysis (EFA)}
\usage{
itemrest(
  data,
  cor_method = "pearson",
  n_factors = NULL,
  extract = "uls",
  rotate = "oblimin"
)
}
\arguments{
\item{data}{A numeric \code{data.frame} or \code{matrix} for the analysis.}

\item{cor_method}{The correlation method to use, e.g., \code{"pearson"} or \code{"polychoric"}.}

\item{n_factors}{The number of factors. If \code{NULL}, it's determined automatically by parallel analysis.}

\item{extract}{The factor extraction (estimation) method. See \code{psych::fa}. Default is \code{"uls"}.}

\item{rotate}{The rotation method. See \code{psych::fa}. Default is \code{"oblimin"}.}
}
\value{
An object of class \code{itemrest_result}. This is a list containing the
following components:
\item{descriptive_stats}{Basic descriptive statistics of the input data.}
\item{initial_efa}{The results of the initial EFA before any items are removed.}
\item{problem_items}{A list of items identified as low-loading or cross-loading.}
\item{removal_summary}{A data.frame summarizing the results of all tested removal strategies.}
\item{optimal_strategy}{The best-performing strategy that resulted in a clean factor structure (no cross-loadings).}
\item{settings}{A list of the settings used for the analysis.}
}
\description{
This function automates the process of identifying low-quality items (those
with low factor loadings or significant cross-loadings) in an Exploratory
Factor Analysis (EFA). It systematically tests various combinations of
removing these problematic items and evaluates the impact on model fit,
returning a comprehensive summary of all tested strategies.
}
\examples{
\donttest{
# We will use the 'bfi' dataset from the 'psych' package.
# This requires the 'psych' package to be installed.
if (requireNamespace("psych", quietly = TRUE)) {
  data(bfi, package = "psych")

  # 1. Prepare the data: Select the personality items (first 25 columns)
  #    and remove rows with missing values for this example.
  example_data <- bfi[, 1:25]
  example_data <- na.omit(example_data)

  # 2. Run the item removal analysis.
  #    Based on theory, the Big Five model has 5 factors.
  results <- itemrest(
    data = example_data,
    n_factors = 5,
    cor_method = "pearson" # Data is not ordinal, so pearson is appropriate
  )

  # 3. Print the report for optimal strategies (default).
  print(results)

  # 4. Print the report for all tested strategies.
  print(results, report = "all")
}
}
}
