% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx_standprop.R
\name{approx_standprop}
\alias{approx_standprop}
\title{Create a daily sequence of stand properties from parameters using
interpolation}
\usage{
approx_standprop(
  x_yrs,
  y,
  y_ini = NULL,
  xout_yrs = x_yrs,
  use_growthperiod = FALSE,
  startdoy = 121,
  enddoy = 279,
  approx.method = "constant",
  return_xout = FALSE
)
}
\arguments{
\item{x_yrs}{A sequence of years or a single year.}

\item{y}{Vector of the same length as \code{x_yrs}. If \code{approx.method = 'linear'},
the values are interpreted to be valid at the end of the respective year in
\code{x_yrs}}

\item{y_ini}{Initial value used as a starting point for linear interpolation.
Interpreted to be valid at the 1st of January of the first year in \code{x_yrs}.
Ignored if \code{approx.method = 'constant'}.}

\item{xout_yrs}{Vector of years for which output is generated. May be
longer or shorter than \code{x_yrs}. For years outside \code{x_yrs}, the value of the
closest data extreme is returned.}

\item{use_growthperiod}{Logical: Use startdoy and enddoy for linear
interpolation? If TRUE, yearly changes take place between startdoy and
enddoy, othe wise from end of year to end of the year after.}

\item{startdoy}{A single value or vector of the same length as \code{x_yrs}, with
the day of year when growth begins.}

\item{enddoy}{A single value or vector of the same length as \code{x_yrs}, with
the day of year when growth cessates.}

\item{approx.method}{Name of interpolation method ('constant' or 'linear').}

\item{return_xout}{Logical: If true, daily values of \code{y} and a date vector are
returned in a data.frame.}
}
\value{
A vector of interpolated daily values
}
\description{
Uses yearly values of inter-annual vegetation development values (e.g. sai,
height, densef, age) and interpolates them to a daily sequence.
}
\details{
For \code{approx.method = 'constant'}, the value of \code{y} is
  returned for the whole respective year in \code{x_yrs}, which results in
  a yearly changing step function. If \code{approx.method = 'linear'}, the
  values of \code{y} are interpolated between the years in \code{x_yrs},
  and interpreted to be reached at the 31st of December of the respective
  \code{x_yrs.} In this case, \code{y_ini} is required as an initial value,
  from which the sequence is interpolated to the first value of \code{y.} The
  linear changes are either accomplished between 31st to 31st of December of
  the years in \code{x_yrs}, or during the growing season only
  (\code{use_growingperiod = TRUE}).
}
\examples{
years <- 2002:2004
height_yearly <- c(20.2,20.8,21.3)

# constant 'interpolation'
height_c <- approx_standprop(x_yrs = years,
                             y = height_yearly)

# linear interpolation
height_ini <- 19.1
height_l <- approx_standprop(x_yrs=years,
                             y = height_yearly,
                             y_ini = height_ini,
                             approx.method = 'linear')

# use growthperiod
height_l_gp <- approx_standprop(x_yrs = years,
                                y = height_yearly,
                                y_ini = height_ini,
                                use_growthperiod = TRUE,
                                startdoy = 121,
                                enddoy = 279,
                                approx.method = 'linear')

dates <- seq.Date(from = as.Date(paste0(min(years),"-01-01")),
                  to = as.Date(paste0(max(years),"-12-31")),
                  by = "day")
plot(dates, height_c,
     type = "l", lwd = 2, col = "black",
     ylim = c(19,22), ylab = "height [m]", xlab = "", xpd = TRUE)
lines(dates, height_l,
      col = "blue", lwd = 2)
lines(dates, height_l_gp,
      col = "green", lwd = 2)
legend("topleft", legend = c("'constant'", "'linear'",
                             "'linear', 'use_growthperiod'"),
       col  = c("black", "blue", "green"),  lwd = 2, pch = NULL,
       bty = "n")
}
