% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SiegelTukey.R
\name{SiegelTukey}
\alias{SiegelTukey}
\alias{twosample.siegel}
\title{Siegel-Tukey Test}
\description{
Performs Siegel-Tukey test on samples.
}
\examples{
pmt(
    "twosample.siegel",
    alternative = "greater", n_permu = 0
)$test(Table2.8.1)$print()

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:TwoSampleTest]{LearnNonparam::TwoSampleTest}} -> \code{\link[LearnNonparam:TwoSampleLocationTest]{LearnNonparam::TwoSampleLocationTest}} -> \code{\link[LearnNonparam:Wilcoxon]{LearnNonparam::Wilcoxon}} -> \code{SiegelTukey}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SiegelTukey-new}{\code{SiegelTukey$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="plot"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-plot'><code>LearnNonparam::PermuTest$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SiegelTukey-new"></a>}}
\if{latex}{\out{\hypertarget{method-SiegelTukey-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{SiegelTukey} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SiegelTukey$new(
  type = c("permu", "asymp"),
  alternative = c("two_sided", "less", "greater"),
  n_permu = 10000,
  correct = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{a character string specifying the way to calculate the p-value.}

\item{\code{alternative}}{a character string specifying the alternative hypothesis.}

\item{\code{n_permu}}{an integer indicating number of permutations for the permutation distribution. If set to \code{0}, all permutations will be used.}

\item{\code{correct}}{a logical indicating whether to apply continuity correction in the normal approximation for the p-value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{SiegelTukey} object.
}
}
}
