% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trans_from_microeco.R
\name{Trans_from_microeco}
\alias{Trans_from_microeco}
\title{Convert a microeco object to a LorMe object}
\usage{
Trans_from_microeco(
  microtab,
  into = "standard",
  outputtax = c("Phylum", "Genus"),
  reads = TRUE
)
}
\arguments{
\item{microtab}{A \code{\link[microeco:microtable]{microtable}} object}

\item{into}{Names of separated taxonomy to create as character vector. Must select from c("Domain","Phylum","Class","Order","Family","Genus","Species").
Shortcut input:1)By default."standard":c("Domain","Phylum","Class","Order","Family","Genus","Species"). Used for standard taxonomy annotation to OTU/ASV table.
2)"complete":c("Domain","Kingdom","Phylum","Class","Order","Family","Genus","Species"). Used for complete taxonomy annotation to meta genomic table.}

\item{outputtax}{Default:c("Phylum","Genus").Names of output taxonomy level table.  Shortcut input is available with 'standard' and 'complete' same as above.}

\item{reads}{Logical.True for reads table and FALSE for percentage table. Default: TRUE}
}
\value{
LorMe object containing taxonomy table data frame,containing reads and percentage table for each specified output.
}
\description{
Convert a microeco object to a LorMe object
}
\note{
For taxonomy annotation with both 'Domain' and 'Kingdom' level, please set 'into' parameter as 'complete'!!!
}
\examples{
## Not run:
if (requireNamespace("microeco", quietly = TRUE)) {
 data("dataset", package = "microeco")

 ## convert microeco object to LorMe format
 dataset_obj <- Trans_from_microeco(dataset, outputtax = "standard")

 ## specify experimental design
 dataset_obj_plan <- object_config(dataset_obj,
                          treat_location = 4)

 ## generate community-structure PCoA plot (Genus level)
 community_structure <- structure_plot(dataset_obj_plan, taxlevel = "Genus")
 community_structure$PCoA_Plot
}
}
