% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-SplitDriveX.R
\name{cubeSplitDriveX}
\alias{cubeSplitDriveX}
\title{Inheritance Cube: X-linked Split CRISPR Drive with 2 Resistance Alleles and male/female specific homing}
\usage{
cubeSplitDriveX(
  cM = 1,
  chM = 0,
  crM = 0,
  cF = 1,
  chF = 0,
  crF = 0,
  ccF = cF,
  cchF = chF,
  ccrF = crF,
  dW = 0,
  dhW = 0,
  drW = 0,
  ddW = dW,
  ddhW = dhW,
  ddrW = drW,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cM}{Cutting efficiency in males}

\item{chM}{Homing efficiency in males}

\item{crM}{Resistance efficiency in males}

\item{cF}{Cutting efficiency in females, one Cas9 allele}

\item{chF}{Homing efficiency in females, one Cas9 allele}

\item{crF}{Resistance efficiency in females, one Cas9 allele}

\item{ccF}{Cutting efficiency in females, two Cas9 alleles}

\item{cchF}{Homing efficiency in females, two Cas9 alleles}

\item{ccrF}{Resistance efficiency in females, two Cas9 alleles}

\item{dW}{Maternal deposition cutting, one Cas9 allele}

\item{dhW}{Maternal deposition homing, one Cas9 allele}

\item{drW}{Maternal deposition resistance, one Cas9 allele}

\item{ddW}{Maternal deposition cutting, two Cas9 alleles}

\item{ddhW}{Maternal deposition homing, two Cas9 alleles}

\item{ddrW}{Maternal deposition resistance, two Cas9 alleles}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This is a X-linked, sex-specific version of a split CRISPR drive. At the X locus
is the Cas9, inherited in a Mendelian fashion. At a second, unlinked, autosomal
locus are the gRNAs. When the two loci occur together, the gRNAs drive, with
potential damaged alleles, but the Cas9 remains Mendelian.
Deposition in this cube is performed when both pieces come together in females.
This drive has 2 loci:
\itemize{
\item "Locus" 1, sex chromosomes, has 3 alleles
\itemize{
\item X: Wild-type X chromosome
\item C: X-chromosome carrying a Cas9 construct
\item Y: Wild-type Y chromosome
}
\item Locus 2, autosomal locus, has 4 alleles:
\itemize{
\item W: Wild-type allele
\item G: gRNA allele
\item R: Functional or low-cost resistance allele
\item B: Non-functional or high-cost resistance allele
}
}
}
