% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yr.R
\name{yr}
\alias{yr}
\title{year with fraction`}
\usage{
yr(x, ...)
}
\arguments{
\item{x}{quantity that can be converted to a \code{Date} object using
\code{as.Date(x)}.}

\item{\dots}{arguments passed to \code{\link[lubridate:ymd]{lubridate::ymd()}}.}
}
\value{
a number (numeric vector).
}
\description{
\code{yr} converts a \code{Date} to a year and fraction. For example, 2025-01-01
becomes 2025.00000, while 2025-01-02 becomes 2025.00234, because (2-1)/365
is 0.00234 to 5 significant digits. However, 2024-01-02 becomes 2024.0233,
because (2-1)/366 is only 0.00233 to 5 significant digits.
}
\examples{
Jan2_24_25 <- c('2024-01-02', '2025-01-02')
J2yr <- yr(Jan2_24_25)
J2y <- yr(as.POSIXct(Jan2_24_25))
all.equal(J2yr, J2y)

}
\seealso{
\code{\link[lubridate:decimal_date]{lubridate::decimal_date()}}, \code{\link[lubridate:ymd]{lubridate::ymd()}}
}
\keyword{manip}
