% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_seq_ratio_pq}
\alias{plot_seq_ratio_pq}
\title{A diagnostic plot of the number of sequences per samples}
\usage{
plot_seq_ratio_pq(physeq, min_nb_seq = 1000, annotations = TRUE)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{min_nb_seq}{(int) The minimum number of sequences per samples to compare
the ratio.}

\item{annotations}{(logical, default TRUE). If FALSE, no annotations are
plotted}
}
\value{
A ggplot2 object
}
\description{
A diagnostic plot of the number of sequences per samples
}
\details{
The x axis depict the number of sequences per samples and the y
axis depicted the ratio of the number of sequences for a given sample
divide by the number of sequences of the previous sample when ordered by
the number of sequences. A high ratio indicate an important and quick
increase of the number of sequence which may indicate that below this
ratio, samples are suspicious.

The general idea is to first removed all samples with definitively not
enough sequences and then, among the kept samples, find the higher
augmentation (ratio) to possibly detect suspicious samples.
}
\examples{
plot_seq_ratio_pq(data_fungi, min_nb_seq = 200)
data(GlobalPatterns)
plot_seq_ratio_pq(GlobalPatterns, min_nb_seq = 100000)
plot_seq_ratio_pq(data_fungi_mini, min_nb_seq = 10, annotations = FALSE)
}
\author{
Adrien Taudière
}
