% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.bv.R
\name{get.bv}
\alias{get.bv}
\title{Export underlying true breeding values}
\usage{
get.bv(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  use.id = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: TRUE)}
}
\value{
Genomic value of in gen/database/cohorts selected individuals
}
\description{
Function to export underlying true breeding values
}
\examples{
data(ex_pop)
get.bv(ex_pop, gen=2)
}
