\name{OrdinalLogBiplotGDRecursive}
\alias{OrdinalLogBiplotGDRecursive}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Ordinal Logistic Biplot with a recursive Gradien Descent Alternating algorithm.
}
\description{
Ordinal Logistic Biplot with a recursive Gradien Descent Alternating algorithm.
}
\usage{
OrdinalLogBiplotGDRecursive(X, freq = matrix(1, nrow(X), 1), dim = 2, tolerance = 1e-04, 
                            penalization = 0.2, num_max_iters = 100, RotVarimax = FALSE, 
                            OptimMethod = "CG", Initial = "random", seed = 0, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{
An ordinal data matrix (in numeric form)
}
  \item{freq}{
A vector of frequenciecies. (not implemented yet)
}
  \item{dim}{
Dimension of the solution.
}
  \item{tolerance}{
Tolerance for the algorithm
}
  \item{penalization}{
Penalization for the algorithm
}
  \item{num_max_iters}{
Maximum number of iterations for the algorithm
}
  \item{RotVarimax}{
Should the solution be rotated?
}
  \item{OptimMethod}{
Optimization method for the algorithm. Conjugated gradient, "CG" by default. See functio "optim" of the stats package.
}
  \item{Initial}{
Initialization of the algorithm. "random" by default. (No other initials implemted)
}
  \item{seed}{
Seed for random numbers. Used to reproductibility of the results.
}
  \item{\dots}{
Anay aditional parametes
}
}
\details{
This function calculates a logistic biplot for ordinal data (Ordinal Logistic Biplot). 
Row scores are computed to yield ordinal logistic responses along the dimensions, 
and column parameters produce logistic response surfaces that, when projected onto 
the space spanned by the row scores, define a linear biplot. 
A proportional odds model is used, resulting in a multidimensional structure similar 
to a graded response model within the IRT framework. The method is based on computational algorithm
for estimating the model parameters and calculating the prediction directions (or axes) used for visualization in the biplot.
The algorithm uses alternating gradient descent procedures. Optimization of the cost funtion is
done using the procedure optimr.
}
\value{
An object of class "Ordinal.Logistic.Biplot"

\item{Data }{The original da matrix with odinal variables in nmeric format}
\item{Dimension }{The dimension of the solution}
\item{Penalization }{The quadratic penalization used in the algorithm}
\item{Tolerance }{The tolerance used in the algorithm}
\item{OptimMethod }{The optimization method used in the algorithm (see optim)}
\item{Biplot }{The kind of biplot used (Ordinal Logistic (Recursive Gradient Descent))}
\item{Type }{The type of biplot used (Ordinal Logistic (Recursive Gradient Descent))}
\item{InitialConfiguration}{The kind of initial configuration used for the lgorithm.}
\item{NumberIterations}{The maximum number of iterations used by the lgorithm.}
\item{RowCoordinates}{Coordinates for the rows of the matrix.}
\item{RowContributions}{Contributions for the rows of the matrix. (not used yet)}
\item{ColCoordinates}{Coordinates for the columns of the matrix.}
\item{loadings}{Loadings of the factor model.}
\item{Thresholds}{Thresholds of the model.}
\item{Communalities}{Communalities of the factor model.}
\item{ColContributions}{Contributions for the columns of the matrix. (squared loadings)}
\item{Expected}{Expected Values}
\item{ColumnParameters}{Several column parameters (not used directly)}
\item{Fit}{Several measures of fit in a table}
\item{Ncats}{Number of categories of each item}
}

\references{
Hernández-Sánchez, J. C., Vicente-González, L., Frutos-Bernal, E., & Vicente-Villardón, J. L. (2025). 
Logistic Biplots for Ordinal Variables Based on Alternating Gradient Descent on the Cumulative Probabilities, 
with an Application to Survey Data. Algorithms, 18(11), 718.
}
\author{
José Luis Vicente-Villardón
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
\dontrun{
bipord=OrdinalLogBiplotGDRecursive(DoctorsNUM, num_max_iters = 10)
plot(bipord, PlotLoadings = FALSE)
}

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
