% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NAP_prior.R
\name{NAP_prior}
\alias{NAP_prior}
\title{NAP_prior: Derive NAP/mNAP/eNAP priors}
\usage{
NAP_prior(
  weight_mtd = c("adaptive", "fixed"),
  w = NULL,
  a = NULL,
  b = NULL,
  y_EC2 = NULL,
  s_EC2 = NULL,
  y_EC1,
  s_EC1,
  y_C2C1,
  s_C2C1,
  mu0 = 0,
  tau0 = 1000,
  lambda = 1,
  sigma2_hat = NULL
)
}
\arguments{
\item{weight_mtd}{Either \code{"adaptive"} (eNAP) or \code{"fixed"} (NP/NAP/mNAP).}

\item{w}{Fixed prior weight in [0,1]; \strong{required only} if \code{weight_mtd="fixed"}. Ignored otherwise.
\verb{0<w<1} infers mixture NAP; \code{w=0} infers NP; \code{w=1} infers NAP.}

\item{a, b}{eNAP tuning parameters; \strong{required only} if \code{weight_mtd="adaptive"}
(\code{a<0} and \code{b>0}). Ignored in fixed mode.}

\item{y_EC2, s_EC2}{Log-HR and SE for \eqn{E:C2} (Current trial post-SoC change).}

\item{y_EC1, s_EC1}{Log-HR and SE for \eqn{E:C1} (Current trial pre-SoC change).}

\item{y_C2C1, s_C2C1}{Historical C2 vs. C1 trial Log-HRs and SEs.}

\item{mu0, tau0}{mean and variance of the vague component (default sqrt(1000)).}

\item{lambda}{Randomization ratio (default 1).}

\item{sigma2_hat}{Positive scalar, required only for multiple external trials setting, leave blank if use default REML estimate, otherwise provide user-specified value}
}
\value{
Displays the NAP prior as a mixture of an informative prior (constructed based on
the indirect evidence path) and a vague prior.

An object of class "NAPrior" (data.frame + attributes).
}
\description{
Builds the informative NAP component (mean/variance from the indirect path)
and the vague component, and reports the mixing weight depending on the mode:
\itemize{
\item \code{weight_mtd = "fixed"}: use the supplied fixed weight \code{w in [0,1]}.
\item \code{weight_mtd = "adaptive"} (eNAP): if \code{y_EC2} is provided, compute the
data-dependent weight via the elastic link; otherwise, print a formula note.
}

Derive NAP-based prior (s) based on indirect evidence

Derive the NAP-based posteriors with provided summary statistics on indirect evidence edges
By default, the function assumes a vague component is desired, as a result, to obtain NAP/mNAP/eNAP:
\itemize{
\item \emph{NAP} Set \code{weight_mtd="fixed"} and \code{w=1}, use the NAP (informative component) column results
\item \emph{mNAP} Set \code{weight_mtd="fixed"} and  \code{w} as pre-specified fixed weight. The resulting mNAP is \eqn{w\pi_{NAP}+(1-w)\pi_0}
\item \emph{eNAP} Set \code{weight_mtd="adaptive"} and provide calibrated \code{a} and \code{b} as from tune_param_eNAP function, then either:
1). Provide assumed value for \code{y_EC2} and \code{s_EC2} (i.e., as for sample size calculation): return a calculated dynamic weight \eqn{w(Z)}, the resulting
eNAP is then \eqn{w(Z)\pi_{NAP}+(1-w(Z))\pi_0};
OR
2). Leave  \code{y_EC2} and \code{s_EC2} as NULL, return the NAP (informative component) and Vague component, with description for protocol reference
}
}
\details{
This function automatically selects one external trial vs multiple external trials setting:
\itemize{
\item One external trial if \code{length(y_C2C1) == 1 & length(s_C2C1)==1}  (one external trial).
\item Multiple external trials if \code{length(y_C2C1) > 1 & length(s_C2C1)==length(y_C2C1)}. By default uses \code{metafor::rma.uni(..., method="REML")} to obtain REML estimate;
Otherwise please provide \code{sigma2_hat}
}
}
\examples{
## ------------------------------------------------------------
## Example 1: One external trial setting with fixed mixing weight of 0.5 (mNAP)
## ------------------------------------------------------------
mNAP_test1 <- NAP_prior(
  weight_mtd = "fixed", w = 0.50,                  # fixed mixture weight
  y_EC1  = -0.36, s_EC1  = 0.16^2,
  y_C2C1 = -0.30, s_C2C1 = 0.14^2,                  # single external trial
  tau0   = 1000
)
print(mNAP_test1)  
plot(mNAP_test1)   

## ------------------------------------------------------------
## Example 2: RE case (multiple historical), ADAPTIVE weight
## ------------------------------------------------------------
eNAP_test1 <- NAP_prior(
  weight_mtd = "adaptive",
  a = -2, b = 10,            # from calibration
  y_EC1  = -0.36, s_EC1  = 0.16^2,                 # E:C1 (current, pre-change)
  y_C2C1 = c(-0.28, -0.35, -0.31),                 # C2:C1 (external trials)
  s_C2C1 = c(0.12^2, 0.11^2, 0.15^2),
  tau0   = 1000                                     # vague variance
)
print(eNAP_test1)

   
}
