% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisModExp.r
\name{LogisModExp}
\alias{LogisModExp}
\alias{dlogis.mod.exp}
\alias{plogis.mod.exp}
\alias{qlogis.mod.exp}
\alias{rlogis.mod.exp}
\alias{hlogis.mod.exp}
\title{Logistic Modified Exponential Distribution}
\usage{
dlogis.mod.exp(x, alpha, beta, lambda, log = FALSE)
plogis.mod.exp(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qlogis.mod.exp(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rlogis.mod.exp(n, alpha, beta, lambda)
hlogis.mod.exp(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlogis.mod.exp}: numeric vector of (log-)densities
  \item \code{plogis.mod.exp}: numeric vector of probabilities
  \item \code{qlogis.mod.exp}: numeric vector of quantiles
  \item \code{rlogis.mod.exp}: numeric vector of random variates
  \item \code{hlogis.mod.exp}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Logistic Modified Exponential distribution.
}
\details{
The Logistic Modified Exponential distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Logistic Modified Exponential distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1-\frac{1}{1+\left[\exp \left\{\lambda x 
e^{\beta x}\right\}-1\right]^\alpha}   \, ; x \geq 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dlogis.mod.exp()} — Density function
  \item \code{plogis.mod.exp()} — Distribution function
  \item \code{qlogis.mod.exp()} — Quantile function
  \item \code{rlogis.mod.exp()} — Random generation
  \item \code{hlogis.mod.exp()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.2)
dlogis.mod.exp(x, 1.5, 1.5, 0.2)
plogis.mod.exp(x, 1.5, 1.5, 0.2)
qlogis.mod.exp(0.5, 1.5, 1.5, 0.2)
rlogis.mod.exp(10, 1.5, 1.5, 0.2)
hlogis.mod.exp(x, 1.5, 1.5, 0.2)

# Data
x <- stress
# ML estimates
params = list(alpha=2.0354, beta=0.1891, lambda=0.1656)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plogis.mod.exp, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlogis.mod.exp, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlogis.mod.exp, pfun=plogis.mod.exp, plot=TRUE)
print.gofic(out) 

}
\references{
Chaudhary, A.K., & Kumar, V.(2020).
A Study on Properties and Applications of Logistic Modified Exponential
Distribution. \emph{International Journal of Latest Trends In Engineering 
and Technology (IJLTET)},\bold{18(1)},19--29.
}
