% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confInt.OEFPIL.R
\name{confInt.OEFPIL}
\alias{confInt.OEFPIL}
\title{Confidence intervals for OEFPIL parameters}
\usage{
confInt.OEFPIL(object, signif.level = object$contents$signif.level, parm)
}
\arguments{
\item{object}{an object of class \code{"OEFPIL"} (a result of a call to \code{\link{OEFPIL}}).}

\item{signif.level}{a numerical value or a vector of significance levels for confidence intervals. If missing, a value from the input \code{"OEFPIL"} object is used.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}
}
\value{
A matrix of estimated confidence intervals for model coefficients from an \code{"OEFPIL"} object. The matrix contains lower and upper confidence limits (columns) for each parameter (rows).
}
\description{
Function computes confidence intervals for the parameters counted by \code{OEFPIL} function.
}
\details{
The confidence intervals are computing under normality assumption.
}
\examples{
\dontshow{
utils::example("coef.OEFPIL",echo=FALSE)}
##-- Continuing the coef.OEFPIL(.) example:

##Use of confint function
#one numerical value
confInt.OEFPIL(st1)

#vector of numerical values
confInt.OEFPIL(st1, signif.level = c(0.01,0.05,0.1))

#estimation of specified parameters
confInt.OEFPIL(st1 , signif.level = c(0.01,0.05,0.1), parm = c('b1','b2'))

}
\seealso{
\code{\link{OEFPIL}}
}
