% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.OEFPIL.R
\name{summary.OEFPIL}
\alias{summary.OEFPIL}
\title{Summary from an OEFPIL object}
\usage{
\method{summary}{OEFPIL}(object, signif.level = object$contents$signif.level, print = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{"OEFPIL"} (a result of a call to \code{\link{OEFPIL}}).}

\item{signif.level}{a significance level for the confidence interval. If missing, a value from the input \code{OEFPIL} object is used.}

\item{print}{print out result summaries in the console (default \code{TRUE}).}

\item{...}{other arguments.}
}
\value{
Returns an object of type list containing following components

 \item{param_Est}{the (numerical) vector of estimated model parameters.}
 \item{sd}{standard deviations for estimated model parameters.}
 \item{cov.m_Est}{the covariance matrix of estimated model parameters.}
 \item{it_num}{number of iterations.}
 \item{CI_parameters}{the matrix of lower and upper bounds for confidence intervals.}
}
\description{
Function for fast and clean output of all basic information of an \code{"OEFPIL"} object.
}
\examples{
\dontshow{
utils::example("coef.OEFPIL",echo=FALSE)}
##-- Continuing the coef.OEFPIL(.) example:

##Use of summary function with default parameters
summary(st1)

##Use of summary function with different parameters
summary(st1, signif.level = 0.01, print = FALSE)

}
\seealso{
\code{\link{OEFPIL}}
}
