\name{gettvc}
\title{Find the most recent value of a time-varying covariate
before each observed response and possibly add them to a list of other
time-varying covariates.}
\usage{
gettvc(response, times=NULL, tvcov=NULL, tvctimes=NULL,
	oldtvcov=NULL, ties=TRUE)
}
\arguments{
\item{response}{A list of two column matrices with response values and
times for each individual, one matrix or dataframe of response
values, or an object of class, response (created by \code{\link{restovec}}).}
\item{times}{When \code{response} is a matrix, a vector of possibly
unequally spaced times for the response, when they are the same for
all individuals or a matrix of times. Not necessary if equally spaced.}
\item{tvcov}{A list of two column matrices with time-varying covariate
values and corresponding times for each individual or one matrix or
dataframe of such covariate values. Times need not be the same as for
responses.}
\item{tvctimes}{When the time-varying covariate is a matrix, a vector
of possibly unequally spaced times for the covariate, when they are
the same for all individuals or a matrix of times. Not necessary if
equally spaced.}
\item{oldtvcov}{A list of matrices with time-varying covariate values,
observed at the event times in \code{response}, for each individual,
or an object of class, tvcov. If not provided, a new object is
created.}
\item{ties}{If TRUE, when the response and covariate times are
identical, the response depends on that new value (as in observational
studies); if FALSE, only the next response depends on that value (for
example, if the covariate is a new treatment just applied at that time).}
}
\description{
\code{gettvc} compares the times of response observations with those of
time-varying covariates to find the most recent observed time-varying
covariate for each response. These are either placed in a new object of
class, tvcov, added to an already existing list of matrices containing
other time-varying covariates and a new object of class, tvcov,
created, or added to an existing object of class, tvcov.
}
\value{
An object of class, tvcov, is returned containing the new time-varying
covariate and, possibly, those in \code{oldtvcov}.
}
\seealso{
\code{\link{carma}}, \code{\link{elliptic}}, \code{\link{gar}},
\code{\link{kalcount}}, \code{\link{kalseries}}, \code{\link{kalsurv}},
\code{\link{read.list}}, \code{\link{restovec}}, \code{\link{tvctomat}}.
}
\examples{
# create a new time-varying covariate object for the response, y
newtvc <- gettvc(y,tvcov=dose)
# add another time-varying covariate to the object
newtvc2 <- gettvc(y,tvcov=bloodpr,oldtvc=newtvc)
}