#' Load Proteomics or Metabolomics Data
#'
#' @param file Path to data file (.csv or .tsv)
#' @param type Type of omics data ("proteomics" or "metabolomics")
#' @return A data frame containing the omics dataset
#' @examples
#' \donttest{
#' # Create a temporary CSV file with example omics data
#' tmp <- tempfile(fileext = ".csv")
#' write.csv(matrix(rnorm(20), nrow = 5), tmp, row.names = FALSE)
#'
#' # Load the omics data
#' data <- load_omics(tmp, type = "proteomics")
#' head(data)
#' }
#' @export
load_omics <- function(file, type = c("proteomics", "metabolomics")) {
  type <- match.arg(type)
  data <- read.csv(file, header = TRUE, stringsAsFactors = FALSE)
  attr(data, "omics_type") <- type
  return(data)
}
