% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseTrend.R
\name{summariseTrend}
\alias{summariseTrend}
\title{Summarise temporal trends in OMOP tables}
\usage{
summariseTrend(
  cdm,
  event = NULL,
  episode = NULL,
  output = "record",
  interval = "overall",
  ageGroup = NULL,
  sex = FALSE,
  inObservation = FALSE,
  dateRange = NULL
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object. Use \emph{CDMConnector} to create a reference
to a database or \emph{omock} to create a reference to synthetic data.}

\item{event}{A character vector of OMOP table names to treat as event tables
(uses only start date).}

\item{episode}{A character vector of OMOP table names to treat as episode
tables (uses start and end date).}

\item{output}{A character vector indicating what to summarise.
Options include \code{"record"} (default), \code{"person"}, \code{"person-days"}, \code{"age"},
\code{"sex"}.
If included, the number of person-days is computed only for episode tables.}

\item{interval}{Time interval to stratify by. It can either be "years",
"quarters", "months" or "overall".}

\item{ageGroup}{A list of age groups to stratify the results by. Each element
represents a specific age range. You can give them specific names, e.g.
\code{ageGroup = list(children = c(0, 17), adult = c(18, Inf))}.}

\item{sex}{Logical; whether to stratify results by sex (\code{TRUE}) or not
(\code{FALSE}).}

\item{inObservation}{Logical. If \code{TRUE}, the results are stratified to
indicate whether each record occurs within an observation period.}

\item{dateRange}{A vector of two dates defining the desired study period.
If \code{dateRange} is \code{NULL}, no restriction is applied.}
}
\value{
A \code{summarised_result} object with the results.
}
\description{
This function summarises temporal trends from OMOP CDM tables, considering
only data within the observation period.
It supports both event and episode tables and can report trends such as
number of records, number of subjects, person-days, median age, and number of
females.
}
\details{
\itemize{
\item \strong{Event tables}:
Records are included if their \strong{start date} falls within the study period.
Each record contributes to the time interval containing the start date.
\item \strong{Episode tables}:
Records are included if their \strong{start or end date} overlaps with the study
period. Records are \strong{trimmed} to the date range, and contribute to
\strong{all} overlapping time intervals between start and end dates.
}
}
\examples{
\donttest{
library(OmopSketch)
library(omock)
library(dplyr)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

result <- summariseTrend(
  cdm = cdm,
  event = c("condition_occurrence", "drug_exposure"),
  episode = "observation_period",
  interval = "years",
  ageGroup = list("<=20" = c(0, 20), ">20" = c(21, Inf)),
  sex = TRUE,
  dateRange = as.Date(c("1950-01-01", "2010-12-31"))
)

plotTrend(result = result, facet = sex ~ omop_table, colour = c("age_group"))

cdmDisconnect(cdm = cdm)
}

}
